% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simPheno.R
\name{sim.phe}
\alias{sim.phe}
\title{Simulation for phenotypes (SimPhe main process)}
\usage{
sim.phe(sim.pars = NULL, fgeno = NULL, ftype = c("ind.head", "plink",
  "snp.head"), fwrite = TRUE, fphename = "simu.pheno",
  fusepar = "usedpars.txt", seed = NA, Dskim = 0, noise.var = 1,
  pattern = "[[:alpha:]]+", plink.path = system("which plink"),
  genetic.model = "epistasis", ...)
}
\arguments{
\item{sim.pars}{a prepared list containing the parameters settings for simulation or a file of parameters settings.
                   Please set your own parameters
                   following the same structure as the object \code{genepars} or as the file
                   \code{simupars.txt}
                   (you could find example file \cr
                   \code{system.file("extdata","simupars.txt",package="SimPhe")}).\cr\cr
                   To specify heritability, there
                   are two ways: one is to set
                   heritability in parameter file or in the prepared list object which will futher pass to \code{sim.pars}.
                   Another way is to set \code{noise.var}
                   by using function \code{\link{get.noise.var}}
                   given specify \code{heritability}. \cr\cr

                   List format: please follow the example of the object \code{genepars}.
                   The meaning of each elment in the list is similar like the file format description below.\cr\cr

                   File format: please follow the example of the \code{simupars.txt} file
                   found in the inst/extdata/ directory of the package (run \cr
                   \code{system.file("extdata", "simupars.txt", package="SimPhe")} \cr
                   to to get the path to the file),
                   blank lines are ignored.
                   The file consists of three or four blocks for each phenotype (the number of blocks depends on user): mean, main and epistasis, sometimes heritability. Each block
                   is started by a line of the form '[blockname]' followed by the parameter setting for the block, e.g. for first phenotype,
\describe{
  \item{[P1mean]}{\describe{
                \item{mean}{\eqn{\beta_{0}}{\beta_0}: coefficient parameter of "basic" genetic effects in
                           \eqn{G_{ij}=\beta_{0}+\sum_{t=1}^{8}\beta_{G_{w_{t}}}w_{tij}}{Gij = \beta_0 + \sum(\beta_Gwt*wtij), t in (1, 2, ..., 8)}. }
                }}
  \item{[P1main]}{\describe{
                \item{SNP}{SNP name}
                \item{additive}{coefficient of additive effect}
                \item{dominance}{coefficient of dominance effect}
                }}
  \item{[P1epistasis]}{\describe{
                    \item{SNPA}{first SNP}
                    \item{SNPB}{second SNP}
                    \item{additive_additive}{coefficient for additive-additive interaction}
                    \item{additive_dominance}{coefficient for additive-dominance interaction}
                    \item{dominance_additive}{coefficient for dominance-additive interaction}
                    \item{dominance_dominance}{coefficient for dominance-dominance interaction}
                    }}
  \item{[P1heritability]}{\describe{
                        \item{heritability}{expected heritability}
                        }}
}
                   Similar meanings for "[P2mean]", "[P2main]", "[P2epistasis]", and so on.}

\item{fgeno}{file to read genotype information from or pre-read data.frame
with that information (matching the output format of
\code{\link{read.geno}}).}

\item{ftype}{genotype file format, it accepts three options:
\describe{
\item{"plink":}{plink format (\code{.bed}, \code{.bim}, \code{.fam} or \code{.map}, \code{.ped});}
\item{"ind.head":}{columns are the indviduals and lines are SNPs;}
\item{"snp.head":}{columns are SNPs and lines are indviduals.}}
                   For "plink", \code{fgeno} needs to be given
                   without suffix and \code{plink.path} may need to be
                   assigned by the user because \code{plink} will be run
                   from within \pkg{SimPhe}. More detail see \code{plink.path}.
                   For the other options, \code{fgeno} should be the full
                   name (with suffix and path if necessary) of the
                   genotype file.
                   Of course, this does not apply if \code{fgeno} is
                   provided as a data frame.}

\item{fwrite}{logical. Write out file (simulated data) or not. If TRUE (default),
simulated phenotypes will be written, respectively.}

\item{fphename}{filename of the phnotype(s). Default is "simu.pheno".}

\item{fusepar}{filename of the setting for simulation (for recording).
Default is "usedpars.txt".}

\item{seed}{an integer used for set.seed(). Default is NA.}

\item{Dskim}{the coefficient of linkage disequilibrium.
Default is 0 (no LD).}

\item{noise.var}{variance for random noise. Default is 1. Note that this
is overridden by the heritability setting in the
simulation parameter file. If heritability is
given in parameter file then \code{noise.var} will not work.}

\item{pattern}{ignore pattern for detecting the phenotype index from the parameter names.
Default is "[[:alpha:]]+" which means letters.}

\item{plink.path}{path of plink executable. Only needed when the \code{ftype}
is "\code{plink}". Default is NULL. The function will detect the plink path with
\code{system("where plink")} for Windows users and \code{system("which plink")} for
Linux and MacOS users. But there is no garantee that the commands work on all devices.
If the path cannot be determined or the executable cannot be called from \code{read.geno},
then users have to try other formats.}

\item{genetic.model}{a string show the genetic model to use for simulation.
Default is "epistasis".}

\item{...}{not used.}
}
\value{
a data.frame with the simulated phenotype(s) where the column(s)
                  refer to different phenotype(s) and rows to individuals.
}
\description{
Main process of simulation for phenotypes
}
\details{
further discussion on pattern
}
\examples{
#### file path of example
# simulation parameters:
fpar.path <- system.file("extdata", "simupars.txt", package="SimPhe")

# genotype file: rows are individuals and columns are SNPs
fgeno.path <- system.file("extdata", "10SNP.txt", package="SimPhe")


#### instead of a parameter file, prepared list like genepars also works
genepars


#### simulate phenotype(s)
phe <- sim.phe(sim.pars = fpar.path, fgeno = fgeno.path, ftype = "snp.head", fwrite = FALSE)
# or
phe <- sim.phe(sim.pars = genepars, fgeno = fgeno.path, ftype = "snp.head", fwrite = FALSE)

# the simulated phenotype(s)
str(phe)
head(phe)
}
\author{
Beibei Jiang \email{beibei_jiang@psych.mpg.de} and
                  Benno Pütz \email{puetz@psych.mpg.de}
}
