% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SISe_sp.R
\name{SISe_sp}
\alias{SISe_sp}
\title{Create a \code{SISe_sp} model}
\usage{
SISe_sp(
  u0,
  tspan,
  events = NULL,
  phi = NULL,
  upsilon = NULL,
  gamma = NULL,
  alpha = NULL,
  beta_t1 = NULL,
  beta_t2 = NULL,
  beta_t3 = NULL,
  beta_t4 = NULL,
  end_t1 = NULL,
  end_t2 = NULL,
  end_t3 = NULL,
  end_t4 = NULL,
  coupling = NULL,
  distance = NULL
)
}
\arguments{
\item{u0}{A \code{data.frame} with the initial state in each node,
i.e., the number of individuals in each compartment in each
node when the simulation starts (see \sQuote{Details}). The
parameter \code{u0} can also be an object that can be coerced
to a \code{data.frame}, e.g., a named numeric vector will be
coerced to a one row \code{data.frame}.}

\item{tspan}{A vector (length >= 1) of increasing time points
where the state of each node is to be returned. Can be either
an \code{integer} or a \code{Date} vector. A \code{Date}
vector is coerced to a numeric vector as days, where
\code{tspan[1]} becomes the day of the year of the first year
of \code{tspan}. The dates are added as names to the numeric
vector.}

\item{events}{a \code{data.frame} with the scheduled events, see
\code{\link{SimInf_model}}.}

\item{phi}{A numeric vector with the initial environmental
infectious pressure in each node. Will be repeated to the
length of nrow(u0). Default is NULL which gives 0 in each
node.}

\item{upsilon}{Indirect transmission rate of the environmental
infectious pressure}

\item{gamma}{The recovery rate from infected to susceptible}

\item{alpha}{Shed rate from infected individuals}

\item{beta_t1}{The decay of the environmental infectious pressure
in interval 1.}

\item{beta_t2}{The decay of the environmental infectious pressure
in interval 2.}

\item{beta_t3}{The decay of the environmental infectious pressure
in interval 3.}

\item{beta_t4}{The decay of the environmental infectious pressure
in interval 4.}

\item{end_t1}{vector with the non-inclusive day of the year that
ends interval 1 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t2}{vector with the non-inclusive day of the year that
ends interval 2 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t3}{vector with the non-inclusive day of the year that
ends interval 3 in each node. Will be repeated to the length
of nrow(u0).}

\item{end_t4}{vector with the non-inclusive day of the year that
ends interval 4 in each node. Will be repeated to the length
of nrow(u0).}

\item{coupling}{The coupling between neighboring nodes}

\item{distance}{The distance matrix between neighboring nodes}
}
\value{
\code{SISe_sp}
}
\description{
Create a \code{SISe_sp} model to be used by the simulation
framework.
}
\details{
The \code{SISe_sp} model contains two compartments; number of
susceptible (S) and number of infectious (I). Additionally, it
contains an environmental compartment to model shedding of a
pathogen to the environment. Moreover, it also includes a spatial
coupling of the environmental contamination among proximal nodes
to capture between-node spread unrelated to moving infected
individuals. Consequently, the model has two state transitions,

\deqn{S \stackrel{\upsilon \varphi S}{\longrightarrow} I}{
S -- upsilon phi S --> I}

\deqn{I \stackrel{\gamma I}{\longrightarrow} S}{
I -- gamma I --> S}

where the transition rate per unit of time from susceptible to
infected is proportional to the concentration of the environmental
contamination \eqn{\varphi}{phi} in each node. Moreover, the
transition rate from infected to susceptible is the recovery rate
\eqn{\gamma}, measured per individual and per unit of
time. Finally, the environmental infectious pressure in each node
is evolved by,

\deqn{\frac{d \varphi_i(t)}{dt} = \frac{\alpha I_{i}(t)}{N_i(t)} +
\sum_k{\frac{\varphi_k(t) N_k(t) - \varphi_i(t) N_i(t)}{N_i(t)}
\cdot \frac{D}{d_{ik}}} - \beta(t) \varphi_i(t)}{
dphi(t)/dt=
alpha I / N +
D*sum_k(phi_k*N_k-phi_i*N_i)/(d_ik*N_i)-beta*phi_i}

where \eqn{\alpha} is the average shedding rate of the pathogen to
the environment per infected individual and \eqn{N = S + I} the
size of the node. Next comes the spatial coupling among proximal
nodes, where \eqn{D} is the rate of the local spread and
\eqn{d_{ik}} the distance between holdings \eqn{i} and
\eqn{k}. The seasonal decay and removal of the pathogen is
captured by \eqn{\beta(t)}. The environmental infectious pressure
\eqn{\varphi(t)}{phi(t)} in each node is evolved each time unit by
the Euler forward method. The value of \eqn{\varphi(t)}{phi(t)} is
saved at the time-points specified in \code{tspan}.

The argument \code{u0} must be a \code{data.frame} with one row for
each node with the following columns:
\describe{
\item{S}{The number of sucsceptible}
\item{I}{The number of infected}
}
}
\section{Beta}{

The time dependent beta is divided into four intervals of the year
\preformatted{
where 0 <= day < 365

Case 1: END_1 < END_2 < END_3 < END_4
INTERVAL_1 INTERVAL_2     INTERVAL_3     INTERVAL_4     INTERVAL_1
[0, END_1) [END_1, END_2) [END_2, END_3) [END_3, END_4) [END_4, 365)

Case 2: END_3 < END_4 < END_1 < END_2
INTERVAL_3 INTERVAL_4     INTERVAL_1     INTERVAL_2     INTERVAL_3
[0, END_3) [END_3, END_4) [END_4, END_1) [END_1, END_2) [END_2, 365)

Case 3: END_4 < END_1 < END_2 < END_3
INTERVAL_4 INTERVAL_1     INTERVAL_2     INTERVAL_3     INTERVAL_4
[0, END_4) [END_4, END_1) [END_1, END_2) [END_2, END_3) [END_3, 365)
}
}

