% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimInf_events.R
\name{select_matrix<-}
\alias{select_matrix<-}
\title{Set the select matrix for a \code{SimInf_model} object}
\usage{
select_matrix(model) <- value
}
\arguments{
\item{model}{The \code{model} to set the select matrix for.}

\item{value}{A matrix.}
}
\description{
Utility function to set \code{events@E} in a \code{SimInf_model}
object, see \code{\linkS4class{SimInf_events}}
}
\examples{
## Create an SIR model
model <- SIR(u0 = data.frame(S = 99, I = 1, R = 0),
             tspan = 1:5, beta = 0.16, gamma = 0.077)

## Set the select matrix
select_matrix(model) <- matrix(c(1, 0, 0, 1, 1, 1, 0, 0, 1), nrow = 3)

## Extract the select matrix from the model
select_matrix(model)
}
