% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SEIR.R
\name{SEIR}
\alias{SEIR}
\title{Create a SEIR model}
\usage{
SEIR(u0, tspan, events = NULL, beta = NULL, epsilon = NULL,
  gamma = NULL)
}
\arguments{
\item{u0}{A \code{data.frame} with the initial state in each node,
see details.}

\item{tspan}{A vector (length >= 2) of increasing time points
where the state of each node is to be returned. Can be either
an \code{integer} or a \code{Date} vector. A \code{Date}
vector is coerced to a numeric vector as days, where
\code{tspan[1]} becomes the day of the year of the first year
of \code{tspan}. The dates are added as names to the numeric
vector.}

\item{events}{a \code{data.frame} with the scheduled events, see
\code{\link{SimInf_model}}.}

\item{beta}{The transmission rate from susceptible to exposed.}

\item{epsilon}{The incubation rate from exposed to infected.}

\item{gamma}{The recovery rate from infected to recovered.}
}
\value{
\code{SEIR}
}
\description{
Create a SEIR model to be used by the simulation framework.
}
\details{
The argument \code{u0} must be a \code{data.frame} with one row for
each node with the following columns:
\describe{
\item{S}{The number of sucsceptible in each node}
\item{I}{The number of infected in each node}
\item{R}{The number of recovered in each node}
}
}
\examples{
## Create a SEIR model object.
model <- SEIR(u0 = data.frame(S = 99, E = 0, I = 1, R = 0),
              tspan = 1:100,
              beta = 0.16,
              epsilon = 0.25,
              gamma = 0.077)

## Run the SEIR model and plot the result.
result <- run(model, seed = 123)
plot(result)
}
