% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.shape.for.all.points.R
\name{flux.shape.for.all.points}
\alias{flux.shape.for.all.points}
\title{Flux shape computing for all points}
\usage{
flux.shape.for.all.points(Etot_fun, A_fun, nu_fun, correl_fun, beta_fun=NULL,
 E_ini_fun=NULL, n_fun=3)
}
\arguments{
\item{Etot_fun}{Numeric. The total concentration}

\item{A_fun}{Numeric vector of activities}

\item{nu_fun}{Numeric value of \bold{canonical} mutation effect}

\item{correl_fun}{Character string indicating the abbreviation of the constraint applied on the system}

\item{beta_fun}{Matrix of co-regulation coefficients}

\item{E_ini_fun}{Numeric vector corresponding to initial concentrations.}

\item{n_fun}{Numeric. Number of enzymes. Necessarily equal to 3 for this function.}
}
\value{
Invisible list of 3 elements:
\itemize{
   \item \code{$J} : Numeric vector of flux.
   \item \code{$sel_disc} : Numeric matrix of \code{n_fun} columns corresponding to discrete selection coefficient, and each row corresponds to one point (i.e. concentration vector).
   Each column correspond to the "mutated" enzyme.
   \item \code{$sel_cont} :Same as \code{$sel_disc}, but for continuous selection coefficient.
   Same properties.
   }
}
\description{
\code{flux.shape.for.all.points} computes flux and selection coefficient for various points (i.ei. vector of concentrations), giving the flux shape
}
\details{
Every enzyme correspond to one dimension in a \emph{n}-dimensional graph.

For various concentration vectors, this function computes flux and selection coefficient.

Selection coefficient are computed from two different expressions (discrete by \code{\link{coef_sel.discrete}} and continuous by \code{\link{coef_sel.continue}}), for a mutation of canonical size \code{nu_fun}.
 
\code{E_ini_fun} is rescaled by a cross product to have sum of \code{E_ini_fun} equal to \code{Etot_fun}.
}
\seealso{
To study shape of flux only from a certain point and for any number of enzymes, see \code{\link{flux.shape.from.one.point}}
}
