% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNV.mean.simul.R
\name{RNV.mean.simul}
\alias{RNV.mean.simul}
\title{Mean of RNV size in simulation}
\usage{
RNV.mean.simul(all_res_sim,end.mean=TRUE,which.sim=NULL,add.lm=TRUE,
add.mean=TRUE,add.pred.e=FALSE,
show.plot=TRUE,new.window=FALSE,cex.lab=1,mar.lab=2.5,...)
}
\arguments{
\item{all_res_sim}{List, the output of function \code{\link{simul.evol.enz.multiple}} (results of evolution simulation).}

\item{end.mean}{Logical. If \code{FALSE}, compute RNV size mean for all rows of \code{res_sim}. If \code{TRUE}, compute RNV size mean for last half of \code{res_sim} rows.}

\item{which.sim}{Numeric vector containing integer numbers between 1 and \code{nsim}. Which simulations would you represent? If \code{NULL} (default), all simulations would be represented.}

\item{add.lm}{Logical. Add line of linear model in graphics?}

\item{add.mean}{Logical. Add mean of RNV size between all selected simulation for each enzyme?}

\item{add.pred.e}{Logical. Add predicted relative concentrations mean between selected simulations? \emph{See concerned graphs in details }}

\item{show.plot}{Logical. Are plots visible?}

\item{new.window}{Logical. Do graphics appear in a new window?}

\item{cex.lab}{Numeric. Size of axis label.}

\item{mar.lab}{Numeric. Distance of label from axis.}

\item{...}{Arguments to be passed in \code{plot} function, such as \code{lwd} or \code{cex}.}
}
\value{
Invisible list of 5 elements:
\itemize{
   \item \code{$RNV_all_sim}: list of \code{nsim} elements (which is the number of simulation). Each element \code{i} contains the output of function \code{\link{RNV.for.simul}} for corresponding simulation \code{i}.
   If simulation is not selected by \code{which.sim}, corresponding element is \code{NULL}. 
   \item \code{$RNV_mean_size}: numeric matrix of \code{n+2} columns and number of rows is between \code{length(which.sim)} and \code{2*length(which.sim)} (depending if there is one or two RNVs).
   Each of the \code{n} first columns is the RNV mean size for corresponding enzyme. Column \code{n+1} indicates the simulation number and column \code{n+2} the RNV number (1 for near RNV and 2 for far RNV).
   \item \code{$rank_var_value}: numeric matrix of \code{n} columns and \code{length(which.sim)} rows. Each cell is the value of the RNV-ranking-order factor to which RNV mean size is compared, for each simulation (in row) (in column) and each enzyme.
   \item \code{$rank_var_name}: character string, indicating the name of the RNV-ranking-order factor.
   \item \code{$lm_RNV}: object of \code{class "lm"}. Linear model of RNV the mean (only for near RNV or RNV number 1) in relation to the RNV-ranking-order factor.
}
}
\description{
Computes mean of RNV size from simulation results and gives a graph of this RNV mean in relation to the RNV-ranking-order factor.
Computes also a linear model of RNV mean in relation to RNV-ranking-order factor.
}
\details{
\code{RNV.mean.simul} works in three parts: \enumerate{
   \item computing mean of RNV size
   \item plotting RNV mean in relation to various variables
   \item computing RNV mean against RNV-ranking-order factor 
}
  
\bold{About RNV mean computing}

Function \code{RNV.mean.simul} is designed to compute mean of RNV size in simulations launched by \code{\link{simul.evol.enz.multiple}}.
Input \code{all_res_sim} is the output of \code{\link{simul.evol.enz.multiple}}.

RNV mean is computed by enzyme and by simulation, and a general mean for each enzyme (between selected simulations) is also computed.

RNV mean is made on all rows in simulation results (\code{end.mean=FALSE}) or only on last half rows of each simulation (\code{end.mean=TRUE}), i.e. when equilibrium is reached.


\bold{About graphics}

Function \code{RNV.mean.simul} gives three graphics: \enumerate{
   \item RNV mean in relation to activities
   \item RNV mean in relation to the RNV-ranking-order factor (see \code{\link{RNV.ranking.order.factor}})
   \item RNV mean in relation to a soft value of the RNV-ranking-order factor (activities A for \code{"SC"} and \code{"Comp"}; global co-regulations coefficients B for \code{"RegPos"} and \code{"RegNeg"}; the hard value of the RNV-ranking-order factor for \code{"CRPos"} and \code{"CRNeg"}). Squares correspond to simulation.
}

Each simulation corresponds to one color. Colors for simulations are taken in palette \code{rainbow}.


\bold{About linear model}

Function \code{RNV.mean.simul} computes also a linear model of RNV mean in relation to the RNV-ranking-order factor between \bold{all} simulations (and not only selected ones by \code{which.sim}).
If wanted, linear model can be put on graphics.



\bold{About logical parameters}

Last graphic is RNV mean in relation to an interest variable, which is activities \bold{A} (\code{"SC"} or \code{"Comp"} cases), global co-regulation coefficients \bold{B} (\code{"RegPos"} or \code{"RegNeg"} cases) or the RNV-ranking-order factor (\code{"CRPos"} or \code{"CRNeg"} cases, see above).

In this last graphic, \code{add.mean=TRUE} adds the mean of RNV size between selected simulations, with black squares and line.

Also in this last graphic, \code{add.pred.e=TRUE} adds mean (between selected simulations) of the predicted relative concentrations at equilibrium, with grey axis, grey dots and grey dashed line.

\code{add.lm=TRUE} adds the linear model (black line) in the second graph (RNV mean against the RNV-ranking-order-factor).
}
\examples{

# With saved simulation
data(data_sim_SC)
RNV.mean.simul(data_sim_SC,new.window=TRUE,which.sim=c(1,5,10))


\donttest{
# case for 3 enzymes
n <- 3
E0 <- c(30,30,30)
kin <- c(1,10,30)
Keq <- c(1,1,1)
nsim <- 2 # 2 simulations
N <- 1000
correl <- "SC"

evol_sim <- simul.evol.enz.multiple(E0,kin,Keq,nsim,N,correl,npt=250)

RNV.mean.simul(evol_sim,new.window=TRUE)
}


}
\seealso{
RNV is computed with function \code{\link{RNV.for.simul}}. 

Use function \code{\link{graph.simul.by.time.RNV}} to have other representations of RNV.

See function \code{\link{RNV.ranking.order.factor}} for details about RNV-ranking-order factor.
}
