% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/flux.R
\name{flux}
\alias{flux}
\title{Flux computation}
\usage{
flux(E_fun,A_fun,X_fun=1)
}
\arguments{
\item{E_fun}{Numeric vector of concentrations}

\item{A_fun}{Numeric vector of activities}

\item{X_fun}{Numeric value. Default is \code{1}}
}
\value{
\code{flux} returns a numeric value
}
\description{
Computes the flux of a metabolic pathway
}
\details{
Computes the flux of a metabolic pathway according to the Metabolic Control Theory (Kacser and Burns, 1973).
}
\examples{
E <- c(1,10,30)
A <- c(30,30,30)
J <- flux(E,A)

#result : J = 26.47059


}
\references{
Kacser, H. and J. A. Burns, 1973. The control of flux. Symp. Soc. Exp. Biol. 27:65–104.

Kacser, H., J. A. Burns, H. Kacser, and D. A. Fell, 1995. The control of flux : 21 years on. Biochemical Society Transactions 23:341–366.
}
\seealso{
Use function \code{\link{activities}} to compute enzyme activities.
}
