% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/RNV.graph.double.at.eq.R
\name{RNV.graph.double.at.eq}
\alias{RNV.graph.double.at.eq}
\title{Graph of e and RNV in relation to A at equilibrium}
\usage{
RNV.graph.double.at.eq(list_eq,posi.legend="topleft",add.title=TRUE,
cex.lab=1,mar.lab=2.5,enz.lab=FALSE,...)
}
\arguments{
\item{list_eq}{Output of function \code{\link{RNV.size.at.equilibr}}:
\itemize{
   \item \code{list_eq$A}: Numeric vector of activities (length \code{n})
   \item \code{list_eq$RNV_size}: Numeric matrix of \code{n} column and 2 rows. Only first row will be used, corresponding to near RNV (small mutations).
   \item \code{list_eq$e_eq}: Numeric vector of equilibrium (length \code{n})
   }}

\item{posi.legend}{Character string. Where would you put legend? See parameter \code{x} in function \code{legend}. If \code{NULL}, legend will not appear.}

\item{add.title}{Logical. Add a title to the plot?}

\item{cex.lab}{Numeric. Size of axis label.}

\item{mar.lab}{Numeric. Distance of label from axis.}

\item{enz.lab}{Logical. Add enzyme name on graph?}

\item{...}{Arguments to be passed to \code{plot} function, such \code{cex} or \code{cex.lab}}
}
\value{
Invisible data.frame of \code{n} rows (one by enzyme) and three columns ($A, $RNV and $e).
}
\description{
Plot of RNV size and relative concentrations in relation to activities at equilibrium
}
\details{
\code{list_eq$A}, \code{list_eq$RNV_size[1,]} and \code{list_eq$e_eq} are binded in a data.frame of \code{n} rows (one by enzyme) and three columns (A, RNV and e),
then ordered according to A.

Title (option \code{add.title=TRUE}) is "Comparing e and RNV at equilibrium".
}
\examples{
list_eq <- RNV.size.at.equilibr(20,"Comp",1000,Etot_0=100,show.plot=FALSE)
RNV.graph.double.at.eq(list_eq)



}
\seealso{
See \code{\link{RNV.size.at.equilibr}} to compute RNV.
}
