% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/util.R
\name{gen_seeds}
\alias{gen_seeds}
\title{Generate random seeds}
\usage{
gen_seeds(design = 1L, iseed = NULL, arrayID = NULL)
}
\arguments{
\item{design}{design matrix that requires a unique seed per condition, or
a number indicating the number of seeds to generate. Default generates one
number}

\item{iseed}{the initial \code{set.seed} number used to generate a sequence
of independent seeds according to the L'Ecuyer-CMRG (2002) method. This
is recommended whenever quality random number generation is required
across similar (if not identical) simulation jobs
(e.g., see \code{\link{runArraySimulation}}). If \code{arrayID} is not
specified then this will return a list of the associated seed for the
full \code{design}}

\item{arrayID}{(optional) single integer input corresponding to the specific
row in the \code{design} object when using the \code{iseed} input.
This is used in functions such as \code{\link{runArraySimulation}}
to pull out the specific seed rather than manage a complete list, and
is therefore more memory efficient}
}
\description{
Generate seeds to be passed to \code{runSimulation}'s \code{seed} input. Values
are sampled from 1 to 2147483647, or are generated using L'Ecuyer-CMRG's (2002)
method (returning either a list if \code{arrayID} is omitted, or the specific
row value from this list if \code{arrayID} is included).
}
\examples{

# generate 1 seed (default)
gen_seeds()

# generate 5 unique seeds
gen_seeds(5)

# generate from nrow(design)
design <- createDesign(factorA=c(1,2,3),
                       factorB=letters[1:3])
seeds <- gen_seeds(design)
seeds

# generate seeds for runArraySimulation()
(iseed <- gen_seeds())  # initial seed
seed_list <- gen_seeds(design, iseed=iseed)
seed_list

# expand number of unique seeds given iseed (e.g., in case more replications
# are required at a later date)
seed_list_tmp <- gen_seeds(nrow(design)*2, iseed=iseed)
str(seed_list_tmp) # first 9 seeds identical to seed_list

# more usefully for HPC, extract only the seed associated with an arrayID
arraySeed.15 <- gen_seeds(nrow(design)*2, iseed=iseed, arrayID=15)
arraySeed.15

}
\author{
Phil Chalmers \email{rphilip.chalmers@gmail.com}
}
