% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SimCorMultRes-package.R
\docType{package}
\name{SimCorMultRes-package}
\alias{SimCorMultRes-package}
\alias{SimCorMultRes}
\title{Simulating Correlated Multinomial Responses}
\description{
Functions to simulate correlated multinomial responses (three or more
nominal or ordinal response categories) and correlated binary responses
subject to a marginal model specification.
}
\details{
The simulated correlated binary or multinomial responses are drawn as
realizations of a latent regression model for continuous random vectors with
the correlation structure expressed in terms of the latent correlation.

For an ordinal response scale, the multinomial variables are simulated
conditional on either a marginal cumulative link model
(\code{\link{rmult.clm}}) or a marginal continuation-ratio model
(\code{\link{rmult.crm}}).

For a nominal response scale, the multinomial responses are simulated
conditional on a marginal baseline-category logit model
(\code{\link{rmult.bcl}}).

Correlated binary responses are simulated using the function
\code{\link{rbin}}.

The threshold approaches that give rise to the implemented marginal models
are fully described in \cite{Touloumis (2016)}.

The formulae are easier to read from either the Vignette or the Reference
Manual (both available
\href{https://CRAN.R-project.org/package=SimCorMultRes}{here}).
}
\references{
Cario, M. C. and Nelson, B. L. (1997) \emph{Modeling and
generating random vectors with arbitrary marginal distributions and
correlation matrix}. Technical Report, Department of Industrial Engineering
and Management Sciences, Northwestern University, Evanston, Illinois.

Emrich, L. J. and Piedmonte, M. R. (1991) A method for generating
high-dimensional multivariate binary variates. \emph{The American
Statistician} \bold{45}, 302--304.

Li, S. T. and Hammond, J. L. (1975) Generation of pseudorandom numbers with
specified univariate distributions and correlation coefficients. \emph{IEEE
Transactions on Systems, Man and Cybernetics} \bold{5}, 557--561.

McCullagh, P. (1980) Regression models for ordinal data. \emph{Journal of
the Royal Statistical Society B} \bold{42}, 109--142.

McFadden, D. (1974) \emph{Conditional logit analysis of qualitative choice
behavior}. New York: Academic Press, 105--142.

Touloumis, A. (2016) Simulating Correlated Binary and Multinomial Responses
under Marginal Model Specification: The SimCorMultRes Package. \emph{The R
Journal} \bold{8}, 79--91.

Touloumis, A., Agresti, A. and Kateri, M. (2013) GEE for multinomial
responses using a local odds ratios parameterization. \emph{Biometrics}
\bold{69}, 633--640.

Tutz, G. (1991) Sequential models in categorical regression.
\emph{Computational Statistics & Data Analysis} \bold{11}, 275--295.
}
\author{
Anestis Touloumis

Maintainer: Anestis Touloumis \email{A.Touloumis@brighton.ac.uk}
}
\keyword{package}
