% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{ClosestFeature}
\alias{ClosestFeature}
\title{Closest Feature}
\usage{
ClosestFeature(object, regions, annotation = NULL, ...)
}
\arguments{
\item{object}{A Seurat object}

\item{regions}{A set of genomic regions to query}

\item{annotation}{A GRanges object containing annotation information. If
NULL, use the annotations stored in the object.}

\item{...}{Additional arguments passed to \code{\link{StringToGRanges}}}
}
\value{
Returns a dataframe with the name of each region, the closest feature
in the annotation, and the distance to the feature.
}
\description{
Find the closest feature to a given set of genomic regions
}
\examples{
\donttest{
ClosestFeature(
  object = atac_small,
  regions = head(granges(atac_small))
)
}
}
\concept{utilities}
