% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R, R/mito.R
\name{AlleleFreq}
\alias{AlleleFreq}
\alias{AlleleFreq.default}
\alias{AlleleFreq.Assay}
\alias{AlleleFreq.Seurat}
\title{Compute allele frequencies per cell}
\usage{
AlleleFreq(object, ...)

\method{AlleleFreq}{default}(object, variants, ...)

\method{AlleleFreq}{Assay}(object, variants, ...)

\method{AlleleFreq}{Seurat}(object, variants, assay = NULL, new.assay.name = "alleles", ...)
}
\arguments{
\item{object}{A Seurat object, Assay, or matrix}

\item{...}{Arguments passed to other methods}

\item{variants}{A character vector of informative variants to keep. For
example, \code{c("627G>A","709G>A","1045G>A","1793G>A")}.}

\item{assay}{Name of assay to use}

\item{new.assay.name}{Name of new assay to store variant data in}
}
\value{
Returns a \code{\link[SeuratObject]{Seurat}} object with a new assay
containing the allele frequencies for the informative variants.
}
\description{
Collapses allele counts for each strand and normalize by the total number of
counts at each nucleotide position.
}
\concept{mito}
