% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/preprocessing.R
\name{NucleosomeSignal}
\alias{NucleosomeSignal}
\title{NucleosomeSignal}
\usage{
NucleosomeSignal(
  object,
  assay = NULL,
  region = "chr1-1-249250621",
  min.threshold = 147,
  max.threshold = 294,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{object}{A Seurat object}

\item{assay}{Name of assay to use. Only required if a fragment path is not provided. If NULL, use the active assay.}

\item{region}{Which region to use. Can be a GRanges region, a string, or a vector of strings. Default is human chromosome 1.}

\item{min.threshold}{Lower bound for the mononucleosome size. Default is 147}

\item{max.threshold}{Upper bound for the mononucleosome size. Default is 294}

\item{verbose}{Display messages}

\item{...}{Additional arguments passed to \code{\link{GetReadsInRegion}}}
}
\value{
Returns a \code{\link[Seurat]{Seurat}} object with
added metadata for the ratio of mononucleosomal to nucleosome-free fragments
per cell, and the percentile rank of each ratio.
}
\description{
Calculate the strength of the nucleosome signal per cell.
Computes the ratio of fragments between 147 bp and 294 bp (mononucleosome) to fragments < 147 bp (nucleosome-free)
}
\examples{
fpath <- system.file("extdata", "fragments.tsv.gz", package="Signac")
atac_small <- SetFragments(object = atac_small, file = fpath)
NucleosomeSignal(object = atac_small)
}
