% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{UpdateSymbolList}
\alias{UpdateSymbolList}
\alias{GeneSymbolThesarus}
\title{Get updated synonyms for gene symbols}
\source{
\url{https://www.genenames.org/} \url{https://www.genenames.org/help/rest/}
}
\usage{
GeneSymbolThesarus(
  symbols,
  timeout = 10,
  several.ok = FALSE,
  search.types = c("alias_symbol", "prev_symbol"),
  verbose = TRUE,
  ...
)

UpdateSymbolList(
  symbols,
  timeout = 10,
  several.ok = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{symbols}{A vector of gene symbols}

\item{timeout}{Time to wait before canceling query in seconds}

\item{several.ok}{Allow several current gene symbols for each
provided symbol}

\item{search.types}{Type of query to perform:
\describe{
 \item{\dQuote{\code{alias_symbol}}}{Find alternate symbols for the genes
 described by \code{symbols}}
 \item{\dQuote{\code{prev_symbol}}}{Find new new symbols for the genes
 described by \code{symbols}}
}
This parameter accepts multiple options and short-hand options
(eg. \dQuote{\code{prev}} for \dQuote{\code{prev_symbol}})}

\item{verbose}{Show a progress bar depicting search progress}

\item{...}{Extra parameters passed to \code{\link[httr]{GET}}}
}
\value{
\code{GeneSymbolThesarus}:, if \code{several.ok}, a named list
where each entry is the current symbol found for each symbol provided and
the names are the provided symbols. Otherwise, a named vector with the
same information.

\code{UpdateSymbolList}: \code{symbols} with updated symbols from
HGNC's gene names database
}
\description{
Find current gene symbols based on old or alias symbols using the gene
names database from the HUGO Gene Nomenclature Committee (HGNC)
}
\details{
For each symbol passed, we query the HGNC gene names database for
current symbols that have the provided symbol as either an alias
(\code{alias_symbol}) or old (\code{prev_symbol}) symbol. All other queries
are \strong{not} supported.
}
\note{
This function requires internet access
}
\examples{
\dontrun{
GeneSybmolThesarus(symbols = c("FAM64A"))
}

\dontrun{
UpdateSymbolList(symbols = cc.genes$s.genes)
}

}
\seealso{
\code{\link[httr]{GET}}
}
\concept{utilities}
