% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{GenePlot}
\alias{GenePlot}
\title{Scatter plot of single cell data}
\usage{
GenePlot(object, gene1, gene2, cell.ids = NULL, col.use = NULL,
  pch.use = 16, cex.use = 1.5, use.imputed = FALSE, use.scaled = FALSE,
  use.raw = FALSE, do.hover = FALSE, data.hover = "ident",
  do.identify = FALSE, dark.theme = FALSE, do.spline = FALSE,
  spline.span = 0.75, ...)
}
\arguments{
\item{object}{Seurat object}

\item{gene1}{First feature to plot. Typically gene expression but can also
be metrics, PC scores, etc. - anything that can be retreived with FetchData}

\item{gene2}{Second feature to plot.}

\item{cell.ids}{Cells to include on the scatter plot.}

\item{col.use}{Colors to use for identity class plotting.}

\item{pch.use}{Pch argument for plotting}

\item{cex.use}{Cex argument for plotting}

\item{use.imputed}{Use imputed values for gene expression (Default is FALSE)}

\item{use.scaled}{Use scaled data}

\item{use.raw}{Use raw data}

\item{do.hover}{Enable hovering over points to view information}

\item{data.hover}{Data to add to the hover, pass a character vector of
features to add. Defaults to cell name and ident. Pass 'NULL' to clear extra
information.}

\item{do.identify}{Opens a locator session to identify clusters of cells.}

\item{dark.theme}{Use a dark theme for the plot}

\item{do.spline}{Add a spline (currently hardwired to df=4, to be improved)}

\item{spline.span}{spline span in loess function call}

\item{\dots}{Additional arguments to be passed to plot.}
}
\value{
No return, only graphical output
}
\description{
Creates a scatter plot of two features (typically gene expression), across a
set of single cells. Cells are colored by their identity class. Pearson
correlation between the two features is displayed above the plot.
}
\examples{
GenePlot(object = pbmc_small, gene1 = 'CD9', gene2 = 'CD3E')

}
