% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotting.R
\name{VizICA}
\alias{VizICA}
\title{Visualize ICA genes}
\usage{
VizICA(object, ics.use = 1:5, num.genes = 30, use.full = FALSE,
  font.size = 0.5, nCol = NULL, do.balanced = FALSE)
}
\arguments{
\item{object}{Seurat object}

\item{ics.use}{Number of ICs to display}

\item{num.genes}{Number of genes to display}

\item{use.full}{Use full ICA (i.e. the projected ICA, by default FALSE)}

\item{font.size}{Font size}

\item{nCol}{Number of columns to display}

\item{do.balanced}{Return an equal number of genes with both + and - IC scores.
If FALSE (by default), returns the top genes ranked by the score's absolute values}
}
\value{
Graphical, no return value
}
\description{
Visualize top genes associated with principal components
}
\examples{
pbmc_small <- RunICA(object = pbmc_small, ics.compute = 25, print.results = FALSE)
VizICA(object = pbmc_small)

}
