% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/alignment.R
\name{CalcVarExpRatio}
\alias{CalcVarExpRatio}
\title{Calculate the ratio of variance explained by ICA or PCA to CCA}
\usage{
CalcVarExpRatio(object, reduction.type = "pca", grouping.var, dims.use,
  verbose = TRUE)
}
\arguments{
\item{object}{Seurat object}

\item{reduction.type}{type of dimensional reduction to compare to CCA (pca,
pcafast, ica)}

\item{grouping.var}{variable to group by}

\item{dims.use}{Vector of dimensions to project onto (default is the 1:number
stored for cca)}

\item{verbose}{Display progress and other output}
}
\value{
Returns Seurat object with ratio of variance explained stored in
object@meta.data$var.ratio
}
\description{
Calculate the ratio of variance explained by ICA or PCA to CCA
}
\examples{
pbmc_small
# Requires CCA to have previously been run
# As CCA requires two datasets, we will split our test object into two just for this example
pbmc1 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[1:40])
pbmc2 <- SubsetData(pbmc_small,cells.use = pbmc_small@cell.names[41:80])
pbmc1@meta.data$group <- "group1"
pbmc2@meta.data$group <- "group2"
pbmc_cca <- RunCCA(pbmc1,pbmc2)
pbmc_cca <- CalcVarExpRatio(pbmc_cca,reduction.type = "pca", grouping.var = "group", dims.use = 1:5)

}
