% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generics.R
\name{get_sigma}
\alias{get_sigma}
\title{Get the covariance matrix}
\usage{
get_sigma(x, ...)
}
\arguments{
\item{x}{Either a 'network', 'network_module', or 'matrix' object.}

\item{...}{Additional arguments.}
}
\value{
A covariance matrix.
}
\description{
The associations in each module are taken as partial correlations, and
the covariance matrix is calculated from these assuming that expression
for gene i is the weighted average over each module using 1/sqrt(m_i) 
as the weight, where m_i is the number of modules containing gene i.
}
\note{
If a matrix is provided, it is assumed to be a partial correlation matrix;
a warning is given in this case. To avoid the warning message, convert the
matrix into a network object using 'create_network_from_association_matrix()'.
}
\examples{
# Create a random network with 10 nodes and add random edge weights.
nw <- random_network(10)
nw <- gen_partial_correlations(nw)
# Get covariance matrix for the network or individual modules in the network.
get_sigma(nw)
module <- nw$modules[[1]]
get_sigma(module)
}
