% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/corr.chn.R
\name{corr.chn}
\alias{corr.chn}
\title{Correct Changes from \code{\link[SemNetCleaner]{textcleaner}}}
\usage{
corr.chn(textcleaner.obj, dictionary = NULL, old)
}
\arguments{
\item{textcleaner.obj}{A \code{\link[SemNetCleaner]{textcleaner}} object}

\item{dictionary}{Character vector.
Can be a vector of a corpus or any text for comparison.
Dictionary to be used for more efficient text cleaning.
Defaults to \code{NULL}, which will use \code{\link[SemNetDictionaries]{general.dictionary}}}

\item{old}{Character vector.
A vector of old response(s) to change.
See the object \code{spellcheck$auto} in
\code{\link[SemNetCleaner]{textcleaner}} output}
}
\value{
This function returns a list containing the
following \code{\link[SemNetCleaner]{textcleaner}} objects, which
have been corrected with the user-provided changes:

\item{binary}{A matrix of responses where each row represents a participant
and each column represents a unique response. A response that a participant has provided is a '\code{1}'
and a response that a participant has not provided is a '\code{0}'}

\item{resposnes}{A response matrix that has been spell-checked and de-pluralized with duplicates removed.
This can be used as a final dataset for analyses (e.g., fluency of responses)}

\item{spellcheck}{A list containing three objects:

\itemize{

\item{\code{full}}
{All responses regardless of spell-checking changes}

\item{\code{unique}}
{Only responses that were changed during spell-check (includes
correct responses that were changed to singular form and lower case)}

\item{\code{auto}}
{Only the incorrect responses that were changed during spell-check}

}

}

\item{removed}{A list containing two objects: 

\itemize{

\item{\code{rows}}
{Identifies removed participants by their row (or column) location in the original data file}

\item{\code{ids}}
{Identifies removed participants by their ID (see argument \code{data}}

}

}

\item{partChanges}{A list where each participant is a list index with each
response that was been changed. Participants are identified by their ID (see argument \code{data}).
This can be used to replicate the cleaning process and to keep track of changes more generally.
Participants with \code{NA} did not have any changes from their original data
and participants with missing data are removed (see \code{removed$ids})}
}
\description{
Allows corrections to changes made by \code{\link[SemNetCleaner]{textcleaner}}.
Some changes may have been made by accident, some changes may have been made
by the automated cleaning, while others may just need to be removed.
This function will correct any changes made in a cleaned \code{\link[SemNetCleaner]{textcleaner}}
object.
}
\details{
This function is used to correct mistakes that occur
in the cleaning process during \code{\link[SemNetCleaner]{textcleaner}}.
There are times when you are too deep into the text cleaning process
that accidentally hitting a '\code{1}' instead of a '\code{2}' does
not make sense to stop and start the text cleaning process over. Rather
when mistakes are made, a record can be kept and this function will
allow those mistakes to be amended.

Old responses should be used as input. A menu will prompt the user
for their decision on how to manage the incorrectly cleaned response.
There are three potential options:

\itemize{

\item{\code{1: TYPE MY OWN}}
{Allows user to type their own response. If multiple responses, then 
commas should separate each response. Quotations are not necessary.}

\item{\code{2: GOOGLE IT}}
{"Googles" the response in question.
A browser will open with the Google search terms: define "RESPONSE"}

\item{\code{3: BAD RESPONSE}}
{When selected, \code{NA} will be returned}

}
}
\examples{
# Toy example
raw <- open.animals[c(1:10),-c(1,2)]

# Clean and prepocess data
clean <- textcleaner(raw, partBY = "row", dictionary = "animals")

# Correct changes
if(interactive())
{corr.clean <- corr.chn (clean, old = "rat", dictionary = "animals")}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
