% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/equate.R
\name{equate}
\alias{equate}
\title{Equate Group Responses}
\usage{
equate(rmatA, rmatB)
}
\arguments{
\item{rmatA}{Binary matrix.
A \link[SemNetCleaner]{textcleaner} filtered response matrix
for binary matrix A}

\item{rmatB}{Binary matrix. 
A \link[SemNetCleaner]{textcleaner} filtered response matrix
for binary matrix B}
}
\value{
A list containing binary matrices that have matching column
names (matching response):

\item{rmatA}{Binary matrix with matched responses for \code{rmatA}}

\item{rmatB}{Binary matrix with matched responses for \code{rmatB}}
}
\description{
In general, this function serves as a wrapper for
\code{\link[SemNetCleaner]{equate.multi}}. This function equates the
responses between two binary response matrices (e.g., two groups)
by only keeping the column names that match between both matrices.
}
\examples{
#finalize rmatA
finalCmat <- finalize(convmat)

#finalize rmatB
finalRmat <- finalize(rmat)

#equate rmatA and rmatB
eq1 <- equate(finalCmat,finalRmat)

#obtain respective equated response matrices
eqCmat <- eq1$rmatA
eqRmat <- eq1$rmatB

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
