% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/autoConverge.R
\name{autoConverge}
\alias{autoConverge}
\title{Automated Converge Responses}
\usage{
autoConverge(rmat)
}
\arguments{
\item{rmat}{Binary matrix.
A \code{\link[SemNetCleaner]{textcleaner}} filtered response matrix}
}
\value{
A list containing four objects:

\item{rmat}{A response matrix that has had responses converged}

\item{converged}{A matrix of responses showing the original response
(\code{from}) and the response that replaced it (\code{to}). If response
was not converged, then it stays the same}

\item{changed}{A matrix of responses that were changed. The original
response (\code{from}) and the response that replaced it (\code{to}).
If responses were removed, then \code{<NA>} is displayed}

\item{participant}{A list of each response with each participant affected}
}
\description{
Automated \code{\link[SemNetCleaner]{converge}} function which merges
of columns of binarized response data with another.
This function streamlines the merging of like responses with other
like responses (e.g., "roaches" with "cockroaches")
into one singular function.
}
\examples{
rmat <- rmat

\dontrun{

#text cleaned
clean <- textcleaner(rmat)

#Automated converge
convmat <- autoConverge(clean)
}

}
\author{
Alexander Christensen <alexpaulchristensen@gmail.com>
}
