% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Diagnostics.R
\name{checkEventObservationIndependenceAssumption}
\alias{checkEventObservationIndependenceAssumption}
\title{Check diagnostic for event-dependent observation end}
\usage{
checkEventObservationIndependenceAssumption(sccsModel, nullBounds = c(0.5, 2))
}
\arguments{
\item{sccsModel}{A fitted SCCS model as created using \code{\link[=fitSccsModel]{fitSccsModel()}}.}

\item{nullBounds}{The bounds for the null hypothesis on the incidence rate ratio scale.}
}
\value{
A tibble with one row and four columns: \code{ratio} indicates the estimates incidence rate ratio for the
probe at the end of observation. \code{lb} and \code{ub} represent the upper and lower bounds of the 95 percent
confidence interval, and \code{pass} is \code{TRUE} if the confidence interval intersects the null bounds.
}
\description{
This diagnostic tests whether there is a dependency between the event and the end of observation.
It does so by adding a probe window at the end of observation, and checking whether the rate of
the outcome is elevated (or decreased) during this window.

The end of observation probe window will automatically be added to the model by the
\code{createSccsIntervalData()} function, unless the \code{endOfObservationEraLength} argument is set to 0.
This function extracts the estimate for that window from the model, and compares it to the
\code{nullBounds}.#'
}
