% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scores.R
\name{roc_score_vec}
\alias{roc_score_vec}
\title{ROC score (AUC)}
\usage{
roc_score_vec(probs, obs)
}
\arguments{
\item{probs}{vector with probabilities (between 0 and 1)}

\item{obs}{vector with categorical observations (as TRUE/FALSE)}
}
\value{
numeric. The ROC score.
}
\description{
Calculates the area under curve (AUC) or ROC-score from a vector of probabilities and corresponding observations.
Formula (1a) from Mason&2018 is used in the calculation, corresponding to trapezoidal interpolation.
This is mostly an auxiliary function for the ROCS function, but also used in the ROC-diagram function, where the AUC is added to the diagrams.
}
\examples{
roc_score_vec(probs = c(0.1,0.6,0.3,0.4),
             obs = c(FALSE,TRUE,TRUE,FALSE))
}
