% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/diagrams.R
\name{round_probs}
\alias{round_probs}
\title{auxiliary function for rounding probabilities}
\usage{
round_probs(probs, binwidth = 0.05)
}
\arguments{
\item{probs}{vector of probabilities (between 0 and 1, not percent)}

\item{binwidth}{width of the bins for rounding.}
}
\value{
vector with rounded probabilities
}
\description{
takes a vector of probabilities (between 0 and 1) and rounds them to the scale specified by binwidth. This is used for reliability diagrams,
where one point is drawn for each bin. 0 is always at the center of the first interval for rounding:
E.g. if binwidth = 0.05 (the default), then probabilities up to 0.025 are rounded to 0, probs between 0.025 and 0.075 are rounded to 0.05, etc.
}
\examples{
round_probs(c(0.001,0.7423))
}
