% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/electoralTool.R
\name{cox.shugart}
\alias{cox.shugart}
\title{Cox-Shugart Measure of Proportionality}
\usage{
cox.shugart(v, s, ...)

cox.shugart(v, s, ...)
}
\arguments{
\item{v}{A numeric vector of data values for votes each political party obtained.}

\item{s}{A numeric vector of data values for seats each political party obtained, the election outcome as seats.}

\item{\dots}{Additional arguements (currently ignored)}
}
\value{
A single score given the votes each party received and seats obtained.
}
\description{
Calculate the Cox and Shugart measure of
 proportionalitybased on a vector of votes and a vector for
 the electoral outcome. This measure is also referred to as the regression index.
}
\examples{
if (interactive()) {
# 2012 Queensland state elecion:
pvotes= c(49.65, 26.66, 11.5, 7.53, 3.16, 1.47)
pseats = c(87.64, 7.87, 2.25, 0.00, 2.25, 0.00)

cox.shugart(pvotes, pseats)

# 2012 Quebec provincial election:
pvotes = c(PQ=31.95, Lib=31.20, CAQ=27.05, QS=6.03, Option=1.89, Other=1.88)
pseats = c(PQ=54, Lib=50, CAQ=19, QS=2, Option=0, Other=0)

cox.shugart(pvotes, pseats)
}
}
\author{
Daniel Marcelino \email{dmarcelino@live.com}
}
\seealso{
\code{\link{inv.cox.shugart}}, \code{\link{farina}}, \code{\link{politicalDiversity}}, \code{\link{grofman}}, \code{\link{gallagher}},  \code{\link{lijphart}}. For more details see the Indices vignette: \code{vignette("Indices", package = "SciencesPo")}.
}

