% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Group_nstud.R
\name{Group_nstud}
\alias{Group_nstud}
\title{Aggregate the students number data by class at the municipality and province level}
\usage{
Group_nstud(
  data = NULL,
  Year = 2023,
  check = TRUE,
  verbose = TRUE,
  check_registry = "Any",
  InnerAreas = TRUE,
  ord_InnerAreas = FALSE,
  check_ggplot = FALSE,
  missing_to_1 = FALSE,
  input_Registry2 = NULL,
  input_InnerAreas = NULL,
  input_Prov_shp = NULL,
  input_School2mun = NULL,
  input_AdmUnNames = NULL,
  autoAbort = FALSE,
  ...
)
}
\arguments{
\item{data}{Either an object of class \code{list}, obtained as output of the \code{\link{Get_nstud}} function,
or an object of class class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the \code{\link{Util_nstud_wide}} function,
if \code{NULL}, the function will download it automatically but it will not be saved in the global environment. \code{NULL} by default.}

\item{Year}{Numeric or character value. The reference school year, if either of the \code{input_} arguments must be retrieved.
Available in the formats: \code{2022}, \code{"2022/2023"}, \code{"202223"}, \code{"20222023"}. \code{2023} by default}

\item{check}{Logical. If \code{TRUE}, the function runs the test of the students number availability across all school included in the school registries (see \code{\link{Util_Check_nstud_availability}}). \code{TRUE} by default}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{check_registry}{Character. If \code{check == TRUE}, the school registries included in the \code{input_School2mun} object (see \code{\link{Get_School2mun}}) whose availability has to be checked. Either \code{"Registry1"} (buildings section), \code{"Registry2"} (registry section), \code{"Any"} or \code{"Both"}. \code{"Any"} by default.}

\item{InnerAreas}{Logical. If \code{check == TRUE}, Whether it must be checked if municipalities belong to Inner areas or not. \code{TRUE} by default.}

\item{ord_InnerAreas}{Logical. If \code{check == TRUE} and \code{InnerAreas == TRUE}, whether the Inner areas classification should be treated as an ordinal variable rather than as a categorical one (see \code{\link{Get_InnerAreas}} for the classification).
\code{FALSE} by default.}

\item{check_ggplot}{Logical. If \code{check == TRUE}, whether to display or not a static map of the availability of the students number by province; see also \code{\link{Util_Check_nstud_availability}}. \code{TRUE} by default.}

\item{missing_to_1}{Logical. Only needed if \code{data} is not provided in wide format. Whether the number of classes should be imputed to 1 when it is missing; see \code{\link{Util_nstud_wide}}. \code{FALSE} by default.}

\item{input_Registry2}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Get_Registry}}
If \code{check == TRUE}, the school registry from the registry section.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default}

\item{input_InnerAreas}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
The classification of peripheral municipalities, obtained as output of the \code{\link{Get_InnerAreas}} function.
Needed only if \code{check == TRUE} and \code{InnerAreas == TRUE}.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default}

\item{input_Prov_shp}{Object of class \code{sf}, \code{tbl_df}, \code{tbl}, \code{data.frame}. The relevant shapefile of Italian municipalities, if both the \code{check} and \code{check_ggplot} options are chosen.
If \code{NULL} it is downloaded automatically but not saved in the global environment. \code{NULL} by default.}

\item{input_School2mun}{Object of class \code{list} with elements of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Get_School2mun}}.
The mapping from school codes to municipality (and province) codes. Needed only if `check == TRUE`.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment. \code{NULL} by default.}

\item{input_AdmUnNames}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, obtained as output of the function \code{\link{Get_AdmUnNames}}
The ISTAT file including all the codes and the names of the administrative units for the year in scope.
Only needed if \code{check == TRUE} and the argument \code{input_School2mun} is \code{NULL}.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment. \code{NULL} by default.}

\item{autoAbort}{Logical. In case any data must be retrieved, whether to automatically abort the operation and return NULL in case of missing internet connection or server response errors. \code{FALSE} by default.}

\item{...}{Additional arguments to the function \code{\link{Util_nstud_wide}} if \code{data} is not provided.}
}
\value{
An object of class \code{list} including:

\itemize{
  \item \code{$Municipality_data}:
   object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, the output dataframe detailed at the municipality level

  \item \code{$Province_data}: object of class 'tbl_df', 'tbl' and 'data.frame', the output dataframe detailad at the province level
 }
}
\description{
This function creates two dataframes with the number of students, classes and students by class, aggregated at the province and municipality level
}
\details{
Numerical variables are summarised by the mean; Boolean variables are summarised by the mean as well, thus they become frequency indicators.
Qualitative values, if included, are summarised by the mode. Summary measures do not include NAs.
}
\examples{
Year <- 2023

nstud23_aggr <- Group_nstud(data = example_input_nstud23, Year = Year,
                           input_Registry2 = example_input_Registry23,
                           InnerAreas = FALSE,  input_School2mun = example_School2mun23)

summary(nstud23_aggr$Municipality_data[,c(46,47,48)])

summary(nstud23_aggr$Province_data[,c(44,45,46)])


}
