% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Group_DB_MIUR.R
\name{Group_DB_MIUR}
\alias{Group_DB_MIUR}
\title{Aggregate the database of Italian public schools buildings at the municipality and province level}
\usage{
Group_DB_MIUR(
  data = NULL,
  Year = 2023,
  count_units = TRUE,
  countname = "nbuildings",
  count_missing = TRUE,
  verbose = TRUE,
  track_deleted = TRUE,
  InnerAreas = TRUE,
  ord_InnerAreas = FALSE,
  input_InnerAreas = NULL,
  ...
)
}
\arguments{
\item{data}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}. The database of school buildings, preferably already converted to numeric, obtained via \code{\link{Util_DB_MIUR_num}}}

\item{Year}{Numeric or Character. The reference school year, if either \code{data} or \code{input_InnerAreas} must be retrieved.
Available in the formats: \code{2023}, \code{"2022/2023"}, \code{202223}, \code{20222023}.
Important: use the same \code{Year} argument used to retrieve the input school buildings data if they are provided as input. \code{2023} by default}

\item{count_units}{Logical. Whether the rows to aggregate at each level must be counted or not. True by default.}

\item{countname}{character. The name of the variable indicating the number of schools included in each municipality of province,
if the argument 'count' is \code{TRUE}. \code{"nbuildings"}  by default.}

\item{count_missing}{Logical. Whether the function should return two dataframes including the percentage of NAs in the \code{data} object at the territorial level. \code{TRUE} by default}

\item{verbose}{Logical. If \code{TRUE}, the user keeps track of the main underlying operations. \code{TRUE} by default.}

\item{track_deleted}{Logical. If \code{TRUE}, the function returns the IDs of schools not included. \code{TRUE} by default.}

\item{InnerAreas}{Logical. Whether an indicator of the percentage of schools belonging to peripheral (Inner) areas mus be included or not.}

\item{ord_InnerAreas}{Logical. Whether the Inner areas classification should be treated as an ordinal variable rather than as a binary one (see \code{\link{Get_InnerAreas}} for the classification).
Please notice than the function creates a column for each class, and if this database must be used in a statistical model, one of the 6 resulting columns must be dropped.
False by default.}

\item{input_InnerAreas}{Object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
The classification of peripheral municipalities, needed only if \code{InnerAreas == TRUE}, obtained as output of the \code{\link{Get_InnerAreas}} function.
If \code{NULL}, it will be downloaded automatically, but not saved in the global environment.
\code{NULL} by default}

\item{...}{Additional arguments to the function \code{Util_DB_MIUR_num} in case no data are provided or data.}
}
\value{
An object of class \code{list} including:

\itemize{
  \item \code{$Municipality_data}:
   object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, the output dataframe detailed at the municipality level;
   all variables besides the first 5 (which identify the record) are numeric

  \item \code{$Province_data}: object of class 'tbl_df', 'tbl' and 'data.frame', the output dataframe detailad at the province level;
  all variables besides the first 3 (which identify the record) are numeric

  \item \code{$Municipality_missing} (Only if \code{count_missing == TRUE}); object of class \code{tbl_df}, \code{tbl} and \code{data.frame}, the percentage of NAs in each variable at the municipality level.

  \item \code{$Province_missing}: (Only if \code{count_missing == TRUE}); object of class 'tbl_df', 'tbl' and 'data.frame', the percentage of NAs in each variable at the province level.
  \item \code{$deleted}: character vector. The schools removed from the original dataframe for data quality reasons. This object is returned only if \code{track_deleted == TRUE}
 }
}
\description{
This function transforms the output of the \code{\link{Util_DB_MIUR_num}} function (which is detailed at the level of single school buildings) at the municipality/LAU and province/NUTS-3 level.
It also allows the user to classify the grade of centrality of municipalities through the variable  \code{Inner_area}.
}
\details{
Numerical variables are summarised by the mean; Boolean variables are summarised by the mean as well, thus they become frequency indicators.
Qualitative values, if included, are summarised by the mode. Summary measures do not include NAs.
The output dataframes are also detailed at the school order level (i.e. Primary, Midde, High school, or different orders). This means that rows are unique combinations of territorial unities and school order.
}
\examples{


library(magrittr)
DB23_MIUR <- example_input_DB23_MIUR \%>\% Util_DB_MIUR_num(verbose = FALSE) \%>\%
    Group_DB_MIUR(InnerAreas = FALSE)



DB23_MIUR$Municipality_data[, -c(1,2,4)]

DB23_MIUR$Province_data[, -c(1,3)]






}
