% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Get_Registry.R
\name{Get_Registry}
\alias{Get_Registry}
\title{Download the registry of Italian public schools from the school registry section}
\source{
\href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/?area=Scuole}{Homepage}
}
\usage{
Get_Registry(
  Year = 2023,
  filename = c("SCUANAGRAFESTAT", "SCUANAAUTSTAT"),
  show_col_types = FALSE
)
}
\arguments{
\item{Year}{Numeric or character. Reference school year (last available is 2024).
Available in the formats: \code{2023}, \code{"2022/2023"}, \code{202223}, \code{20222023}. \code{2023} by default.}

\item{filename}{Character. A string included in the name of the file to download, identifying the schools included.
By default it is \code{c("SCUANAGRAFESTAT", "SCUANAAUTSTAT")}, i.e. the file names used for public school registries,
respectively across all the national territory except for the autonomous provinces of Aosta, Trento or Bozen, and only in the three
If instead the registry of the private schools is needed, please insert \code{"SCUANAGRAFEPAR"} and/or \code{"SCUANAAUTPAR"}.

For the registry of private schools, either in all the national territory except for the aforementioned provinces, and for these provinces, please use \code{"SCUANAGRAFEPAR"} and \code{"SCUANAAUTPAR"} respectively. Please notice that data regarding private schools are not available for most functions in this package.}

\item{show_col_types}{Logical. If \code{TRUE}, the columns of the raw dataset are shown during the download. \code{FALSE} by default.}
}
\value{
An object of class \code{tbl_df}, \code{tbl} and \code{data.frame}.
}
\description{
This function returns two main pieces of information regarding Italian schools, namely:
\itemize{
  \item The denomination of the region, province and municipality to which the school belongs.
  \item The mechanographical code to the reference institute of each school.
}
It is possible to access schools in all the national territory, including the autonomous provinces of Aosta, Trento and Bozen.
}
\details{
Schools different from primary, middle or high schools are classified as \code{"NR"}.
}
\examples{

\donttest{
  Get_Registry(2024, filename = "SCUANAGRAFESTAT")
}




}
