#' Subset of the school buildings database in school year 2022/23
#'
#'
#' This dataframe includes the schools directly identifiable as primary, middle or high school, from four regions: Molise, Campania, Apulia and Basilicata.
#' Only the first 35 columns are included.
#' The whole dataset can be retrieved with the command \code{Get_DB_MIUR(2023)}
#' @seealso \code{\link{Get_DB_MIUR}}
#'
#' @format ## `example_input_DB23_MIUR`
#' A data frame with 7479 rows and 35 columns:
#' \itemize{
#'   \item \code{Year} Numeric; the school year.
#'   \item \code{School_code} Character; the school ID.
#'   \item \code{Order} Character; the school order, either primary, middle or high school.
#'   \item \code{Reference_institute_code} Character; the ID of the reference institute.
#'   \item \code{Building_code} Character; the building ID; the first 6 digits usually identify the municipality.
#'   \item \code{Municipality_code} Character; the ISTAT LAU (municipality) ID.
#'   \item \code{Municipality_description} Character; the municipality name.
#'   \item \code{Province_initials} Character; abbreviated NUTS-3 denomination.
#'   \item \code{Postal_code} Character; the ZIP code; slightly finer than municipality boundaries. for big municipalities.
#'   \item \code{Context_without_disturbances} Character; whether the school belongs to an environment devoid of disturbances; otherwise, the types of disturbances are listed in columns 11 - 18.
#'   \item \code{Dumps_proximity} Character; whether the school is close to dumps (disturbance element).
#'   \item \code{Pollutant_industries_proximity} Character; whether the school is close to pollutant industries (disturbance element).
#'   \item \code{Pollutant_waters_proximity} Character; whether the school is close to pollutant or stagnant streams or ponds (disturbance element).
#'   \item \code{Air_pollution_sourcer_proximity} Character; whether the school is close to sources of air pollution (disturbance element).
#'   \item \code{Acoustic_pollution_sourcer_proximity} Character; whether the school is close to sources of acoustic pollution (disturbance element).
#'   \item \code{Electromagnetic_radiation_sources_proximity} Character; whether the school is close to sources of electromagnetic radiation (disturbance element).
#'   \item \code{Graveyards_proximity} Character; whether the school is close to a graveyard (disturbance element).
#'   \item \code{Other_disturbances_proximity} Character; other disturbance elements to which the school is close, other than those already listed.
#'   \item \code{School_area_specific_criticalities} Character; whether any specific criticality element occurs inside the school area; specified in columns 20 - 27.
#'   \item \code{Layby absence} Character; whether the access to the area pertaining to the school building lacks a lay-by or pitch (school area criticality element).
#'   \item \code{Unfenced area} Character; whether the school building area lacks fences or enclosures (school area criticality element).
#'   \item \code{Large_traffic} Character; whether the school area is close to large traffic streams (school area criticality element).
#'   \item \code{Railway_traffic} Character; whether the school area is close to railway traffic streams (school area criticality element).
#'   \item \code{Abandoned_industries} Character; whether the school area is located in pre-existences of abandoned industries (school area criticality element).
#'   \item \code{Decayed_urban_area} Character; whether the school belongs or is close to a decayed area (school area criticality element).
#'   \item \code{Risky_industries_proximity} Character; whether the school is close to perilous industrial areas  (school area criticality element).
#'   \item \code{Other_specific_criticalities} Character; specific criticality elements regarding the school area, other than those already listed.
#'   \item \code{School_bus} Character; whether the school is reached by school-bus service.
#'   \item \code{Urban_public_transport} Character; whether the school is served by a urban public transport station in the range of 250 meters.
#'   \item \code{Interurban_public_transport} Character; whether the school is served by a inter-urban public transport station in the range of 500 meters.
#'   \item \code{Railway_transport} Character; whether the school ranges 500 meters or less from a train station.
#'   \item \code{Private_transport} Character; whether the school can be reached by private transport.
#'   \item \code{Disabled_people_transport} Character; whether the school is provided with disabled people specific transport.
#'   \item \code{Bicycle_lane} Character; whether the building is in proximity of a bicycle/bike lane.
#'   \item \code{Other} Character; whether the building can be reached in any other specific way.
#' }
#' @source \href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/?area=Edilizia+Scolastica}{Homepage}; more in detail, the dataset blocks are downloaded respectively from:
#' \href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/leaf/?area=Edilizia+Scolastica&datasetId=DS0111EDIAMBIENTESTA2021}{cols 10-18};
#' \href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/leaf/?area=Edilizia+Scolastica&datasetId=DS0121EDICOLLEGAMENTISTA2021}{cols 20-27};
#' \href{https://dati.istruzione.it/opendata/opendata/catalogo/elements1/leaf/?area=Edilizia+Scolastica&datasetId=DS0121EDICOLLEGAMENTISTA2021}{cols 28-35}
#'
"example_input_DB23_MIUR"
