% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcScores.R
\name{calcScores}
\alias{calcScores}
\title{Calculates linking scores for a file of interest and linkage data file.}
\usage{
calcScores(FOI, LDF, missing.value = NA, min.parallelblocksize = 1,
  output.varnames = NULL, debug = FALSE)
}
\arguments{
\item{FOI}{A \code{\link[base]{data.frame}} object, \code{\link[base]{matrix}} or 
\code{\link[base]{vector}} to be used as the file of interest. This must contain
only the variables of interest, and these must be in the same order as the LDF.}

\item{LDF}{A \code{\link[base]{data.frame}} object, \code{\link[base]{matrix}} or 
\code{\link[base]{vector}} to be used as the linkage data file. This must contain
only the variables of interest, and these must be in the same order as the FOI.}

\item{missing.value}{Value used to represent missing data; Defaults to NA}

\item{min.parallelblocksize}{The minimum block size when splitting up the data accross
processors. You may wish to change this to optimise the allocation of processors.
see (\url{https://rcppcore.github.io/RcppParallel/#tuning}).}

\item{output.varnames}{Labels to apply to function output; Defaults to column names
of the FOI \code{\link[base]{data.frame}}}

\item{debug}{Boolean indicating whether to output additional debugging information}
}
\value{
A list containing: An numeric \code{\link[base]{vector}} of scores, one for
each of the identifiers of interest and a \code{\link[base]{matrix}} containing A*.
}
\description{
This function calculates a score from two files, the file of interest (FOI)
and linkage data file (LDF).
}
\author{
Goldstein H., and Charlton, C.M.J., (2017) Centre for Multilevel Modelling, University of Bristol.
}
