% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate-mixed-functions.R
\name{estimate_functions_mixed}
\alias{estimate_functions_mixed}
\alias{estimate_k_mixed}
\alias{estimate_k_generic_1RM_mixed}
\alias{estimate_k_1RM_mixed}
\alias{estimate_kmod_mixed}
\alias{estimate_kmod_1RM_mixed}
\alias{estimate_klin_mixed}
\alias{estimate_klin_1RM_mixed}
\title{Estimate relationship between reps and weight using the non-linear mixed-effects regression}
\usage{
estimate_k_mixed(athlete, perc_1RM, reps, eRIR = 0, reverse = FALSE, ...)

estimate_k_generic_1RM_mixed(
  athlete,
  weight,
  reps,
  eRIR = 0,
  k = 0.0333,
  reverse = FALSE,
  random = zeroRM ~ 1,
  ...
)

estimate_k_1RM_mixed(
  athlete,
  weight,
  reps,
  eRIR = 0,
  reverse = FALSE,
  random = k + zeroRM ~ 1,
  ...
)

estimate_kmod_mixed(athlete, perc_1RM, reps, eRIR = 0, reverse = FALSE, ...)

estimate_kmod_1RM_mixed(
  athlete,
  weight,
  reps,
  eRIR = 0,
  reverse = FALSE,
  random = kmod + oneRM ~ 1,
  ...
)

estimate_klin_mixed(athlete, perc_1RM, reps, eRIR = 0, reverse = FALSE, ...)

estimate_klin_1RM_mixed(
  athlete,
  weight,
  reps,
  eRIR = 0,
  reverse = FALSE,
  random = klin + oneRM ~ 1,
  ...
)
}
\arguments{
\item{athlete}{Athlete identifier}

\item{perc_1RM}{\%1RM}

\item{reps}{Number of repetitions done}

\item{eRIR}{Subjective estimation of reps-in-reserve (eRIR)}

\item{reverse}{Logical, default is \code{FALSE}. Should reps be used as predictor instead as a target?}

\item{...}{Forwarded to \code{\link[nlme]{nlme}} function}

\item{weight}{Weight used}

\item{k}{Value for the generic Epley's equation, which is by default equal to 0.0333}

\item{random}{Random parameter forwarded to \code{\link[nlme]{nlme}} function. Default is \code{k + zeroRM ~ 1} for,
\code{\link{estimate_k_mixed}} function, or \code{k + oneRM ~ 1} for \code{\link{estimate_kmod_mixed}} and
\code{\link{estimate_klin_mixed}} functions}
}
\value{
\code{\link[nlme]{nlme}} object
}
\description{
These functions provide estimated 1RM and parameter values using the mixed-effect regression. By default,
target variable is the reps performed, while the predictor is the \code{perc_1RM} or
\code{weight}. To reverse this, use the \code{reverse = TRUE} argument
}
\section{Functions}{
\itemize{
\item \code{estimate_k_mixed()}: Estimate the parameter \code{k} in the Epley's equation

\item \code{estimate_k_generic_1RM_mixed()}: Provides the model with generic \code{k} parameter, as well as
estimated \code{1RM}. This is a novel estimation function that uses the absolute weights

\item \code{estimate_k_1RM_mixed()}: Estimate the parameter \code{k} in the Epley's equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights

\item \code{estimate_kmod_mixed()}: Estimate the parameter \code{kmod} in the Modified Epley's equation

\item \code{estimate_kmod_1RM_mixed()}: Estimate the parameter \code{kmod} in the Modified Epley's equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights

\item \code{estimate_klin_mixed()}: Estimate the parameter \code{klin} in the Linear/Brzycki's equation

\item \code{estimate_klin_1RM_mixed()}: Estimate the parameter \code{klin} in the Linear/Brzycki equation, as well as
\code{1RM}. This is a novel estimation function that uses the absolute weights

}}
\examples{
# ---------------------------------------------------------
# Epley's model
m1 <- estimate_k_mixed(
  athlete = RTF_testing$Athlete,
  perc_1RM = RTF_testing$`Real \%1RM`,
  reps = RTF_testing$nRM
)

coef(m1)
# ---------------------------------------------------------
# Generic Epley's model that also estimates 1RM
m1 <- estimate_k_generic_1RM_mixed(
  athlete = RTF_testing$Athlete,
  weight = RTF_testing$`Real Weight`,
  reps = RTF_testing$nRM
)

coef(m1)
# ---------------------------------------------------------
# Epley's model that also estimates 1RM
m1 <- estimate_k_1RM_mixed(
  athlete = RTF_testing$Athlete,
  weight = RTF_testing$`Real Weight`,
  reps = RTF_testing$nRM
)

coef(m1)
# ---------------------------------------------------------
# Modifed Epley's model
m1 <- estimate_kmod_mixed(
  athlete = RTF_testing$Athlete,
  perc_1RM = RTF_testing$`Real \%1RM`,
  reps = RTF_testing$nRM
)

coef(m1)
# ---------------------------------------------------------
# Modified Epley's model that also estimates 1RM
m1 <- estimate_kmod_1RM_mixed(
  athlete = RTF_testing$Athlete,
  weight = RTF_testing$`Real Weight`,
  reps = RTF_testing$nRM
)

coef(m1)
# ---------------------------------------------------------
# Linear/Brzycki model
m1 <- estimate_klin_mixed(
  athlete = RTF_testing$Athlete,
  perc_1RM = RTF_testing$`Real \%1RM`,
  reps = RTF_testing$nRM
)

coef(m1)
# ---------------------------------------------------------
# Linear/Brzycki model that also estimates 1RM
m1 <- estimate_klin_1RM_mixed(
  athlete = RTF_testing$Athlete,
  weight = RTF_testing$`Real Weight`,
  reps = RTF_testing$nRM
)

coef(m1)
}
