% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trim_hobo_data.R
\name{trim_hobo_data}
\alias{trim_hobo_data}
\title{trim_hobo_data}
\usage{
trim_hobo_data(
  stic_data,
  time_start = "2021-07-16 18:00:00",
  time_end = "2021-07-27 01:00:00"
)
}
\arguments{
\item{stic_data}{A data frame with columns named \code{condUncal} and  \code{datetime}, for example as produced by the function \code{tidy_hobo_data}.}

\item{time_start}{User enters the time at which the logger was placed in the stream network}

\item{time_end}{User enters the time at which the logger was removed from the stream network}
}
\value{
a tidied data frame with the same columns as the input, but trimmed to the user-defined time
}
\description{
This function trims a tidied hobo data frame by datetime to eliminate periods where the logger wad recording but not placed
in the stream network
}
\examples{
trimmed_data <-
  trim_hobo_data(tidy_stic_data,
    time_start = "2021-07-16 18:00:00",
    time_end = "2021-07-27 01:00:00"
  )
head(trimmed_data)
}
