% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LaplacianSVM.R
\name{LaplacianSVMSSLR}
\alias{LaplacianSVMSSLR}
\title{General Interface for LaplacianSVM model}
\usage{
LaplacianSVMSSLR(
  lambda = 1,
  gamma = 1,
  scale = TRUE,
  kernel = kernlab::vanilladot(),
  adjacency_distance = "euclidean",
  adjacency_k = 6,
  normalized_laplacian = FALSE,
  eps = 1e-09
)
}
\arguments{
\item{lambda}{numeric; L2 regularization parameter}

\item{gamma}{numeric; Weight of the unlabeled data}

\item{scale}{logical; Should the features be normalized? (default: FALSE)}

\item{kernel}{kernlab::kernel to use}

\item{adjacency_distance}{character; distance metric used to construct adjacency graph from the dist function. Default: "euclidean"}

\item{adjacency_k}{integer; Number of of neighbours used to construct adjacency graph.}

\item{normalized_laplacian}{logical; If TRUE use the normalized Laplacian, otherwise, the Laplacian is used}

\item{eps}{numeric; Small value to ensure positive definiteness of the matrix in the QP formulation}
}
\description{
model from RSSL package
Manifold regularization applied to the support vector machine as proposed in Belkin et al. (2006). As an adjacency matrix, we use the k nearest neighbour graph based on a chosen distance (default: euclidean).
}
\examples{
library(tidyverse)
library(caret)
library(tidymodels)
library(SSLR)

data(breast)

set.seed(1)
train.index <- createDataPartition(breast$Class, p = .7, list = FALSE)
train <- breast[ train.index,]
test  <- breast[-train.index,]

cls <- which(colnames(breast) == "Class")

#\% LABELED
labeled.index <- createDataPartition(breast$Class, p = .2, list = FALSE)
train[-labeled.index,cls] <- NA

library(kernlab)
m <- LaplacianSVMSSLR(kernel=kernlab::vanilladot()) \%>\%
  fit(Class ~ ., data = train)


#Accesing model from RSSL
model <- m$model

#Accuracy
predict(m,test) \%>\%
  bind_cols(test) \%>\%
  metrics(truth = "Class", estimate = .pred_class)
}
\references{
Belkin, M., Niyogi, P. & Sindhwani, V., 2006. Manifold regularization:
A geometric framework for learning from labeled and unlabeled examples. Journal of
Machine Learning Research, 7, pp.2399-2434.
}
