% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/checkHaplotypeSyntax.R
\name{checkHaplotypeSyntax}
\alias{checkHaplotypeSyntax}
\title{Check haplotype syntax}
\usage{
checkHaplotypeSyntax(haplotype, filename)
}
\arguments{
\item{haplotype}{A haplotype where allele names are written in the IPD-IMGT/HLA Database format, and have 1-4 fields. Alleles in haplotypes may be delimited by "-" or "~".}

\item{filename}{The full file path of the user specified dataset if the user wishes to use their own file, or pre-bundled mock haplotype dataset. User provided datasets must be a .dat, .txt, or.csv file, and must conform to the structure and format of the mock haplotype dataset bundled with the package.}
}
\value{
TRUE if all alleles in entered haplotype have correct syntax and appropriate number of fields. Otherwise, a vector containing FALSE and an error message is returned.
}
\description{
Checks if alleles in a haplotype have correct syntax and an appropriate number of fields.
}
\note{
For internal SSHAARP use only.
}
