% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulateKriging.R
\name{simulationSpectral}
\alias{simulationSpectral}
\title{Kriging Simulation: Spectral Method}
\usage{
simulationSpectral(object, conditionalSimulation = FALSE, Ncos = 100)
}
\arguments{
\item{object}{fit of the Kriging model (settings and parameters), of class \code{kriging}.}

\item{conditionalSimulation}{logical, if set to TRUE (default), the simulation is conditioned with the training data of the Kriging model.
Else, the simulation is non-conditional.}

\item{Ncos}{number of cosine functions used to construct the simulation}

\item{...}{further arguments, not used}
}
\value{
Returned value depends on the setting of \code{object$simulationReturnAll}
}
\description{
(Conditional) Simulation via spectral method.
}
\references{
N. A. Cressie. Statistics for Spatial Data. JOHN WILEY & SONS INC, 1993.

C. Lantuejoul. Geostatistical Simulation - Models and Algorithms. Springer-Verlag Berlin Heidelberg, 2002.
}
\seealso{
\code{\link{buildKriging}}, \code{\link{simulationDecompose}}
}
\keyword{internal}
