% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/spotPredictDice.R
\name{spotPredictDice}
\alias{spotPredictDice}
\title{Meta Model Interface: Dice Kriging}
\usage{
spotPredictDice(rawB, mergedB, design, spotConfig, fit = NULL)
}
\arguments{
\item{rawB}{matrix of raw x and y values}

\item{mergedB}{matrix of merged x and y values, does not have replicate entries}

\item{design}{design points to be evaluated by the meta model}

\item{spotConfig}{the list of all parameters is given.}

\item{fit}{if an existing model fit is supplied, the model will not be build based on 
data, but only evaluated with the model fit (on the design data). To build the model, 
this parameter has to be NULL. If it is not NULL the parameters mergedB and rawB will not be 
used at all in the function.}
}
\value{
returns the list \code{spotConfig} with two new entries:\cr
	spotConfig$seq.modelFit fit of the model used with predict() \cr
spotConfig$seq.largeDesignY the y values of the design, evaluated with the fit
}
\description{
Kriging meta model based on the DiceKriging package.
It usually provides good prediction performance, but is rather unstable.
}
\seealso{
\code{\link{SPOT}}
}

