\name{SPCAvRP_ranking}
\alias{SPCAvRP_ranking}
\title{Ranks the variables}
\description{Ranks the original variables according to their importance in maximising the explained variance in the data by aggregating over selected projections of the sample covariance matrix.}
\usage{SPCAvRP_ranking(data, rand_ind, p, A)}
\arguments{
  \item{data}{A list of projected covariances (see Details).}
  \item{rand_ind}{Corresponding axis-aligned projections (see Details).}
  \item{p}{The dimension of the data.}
  \item{A}{Number of projections over which to aggregate.}
}
\details{This function divides given projections into \code{A} groups and selects the best one from each group. This is then followed by an aggregation step. Data is given as a list of \code{d}-dimensional projections of \code{p}-dimensional sample covariance matrix, as generated by the function \code{\link{project_covariance}}. Corresponding axis-aligned projections are given as a matrix whose rows are the indices of the projection's non-zero entries.}
\value{Returns the vector of indices corresponding to variables ranked by their importance in maximising the explained variance.}
\references{Milana Gataric, Tengyao Wang and Richard J. Samworth (2018) Sparse principal component analysis via random projections
\url{https://arxiv.org/abs/1712.05630}}
\author{Milana Gataric, Tengyao Wang and Richard J. Samworth}
\seealso{\code{\link{SPCAvRP}}}
\examples{
p <-  50 # dimension of data
k <- 5 # true sparsity level
n <- 1000 # number of observations
v1 <- c(rep(1/sqrt(k), k), rep(0,p-k)) # leading eigenvector
Sigma <- tcrossprod(v1) + diag(p) # population covariance
mu <- rep(0, p) # population mean
X <- mvrnorm(n, mu, Sigma) # data matrix
Sigma_hat <- 1/n*crossprod(X) # sample covariance matrix

A <- 200 # number of projections over which to aggregate
B <- 100 # number of projections in a group from which to select
d <- k # dimension of projections
rand_ind <- matrix(replicate(A*B,sample.int(p,d)), nrow = A*B, byrow = TRUE) # random projections

cov_projections <- project_covariance(data = Sigma_hat, cov = TRUE, rand_ind)

ranking <- SPCAvRP_ranking(cov_projections, rand_ind, p, A)
print(ranking)
}
