% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SPARRAfairness_functions.R
\name{groupmetric_2panel}
\alias{groupmetric_2panel}
\title{groupmetric_2panel
Draws plots of a group fairness metric with a second panel underneath}
\usage{
groupmetric_2panel(
  objs,
  labels,
  col = 1:length(objs),
  lty = rep(1, length(col)),
  yrange = NULL,
  ci_col = 1:length(objs),
  highlight = NULL,
  logscale = FALSE,
  mar_scale = 1,
  lpos = NULL,
  yrange_lower = NULL,
  ...
)
}
\arguments{
\item{objs}{list of fairness objects. Each should contain sub-objects 'x', 'y' and 'ci', which specify x and y values and half-widths of confidence intervals around y.}

\item{labels}{labels to use in legend}

\item{col}{line colours}

\item{lty}{line type, defaults to 1}

\item{yrange}{limit of y axis; defaults to 0,1}

\item{ci_col}{confidence envelope colours. These will be transparent.}

\item{highlight}{if non-null, draw a point at a particular cutoff}

\item{logscale}{if TRUE, draw with log-scale.}

\item{mar_scale}{scale bottom and left margins by this amount. Also scales legend.}

\item{lpos}{legend position}

\item{yrange_lower}{y range for lower plot. If NULL, generates automatically}

\item{...}{other parameters passed to legend()}
}
\value{
No return value, draws a figure
}
\description{
groupmetric_2panel
Draws plots of a group fairness metric with a second panel underneath
}
\examples{
# See vignette
}
