% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fastphase.R
\name{SNPknock.fp.loadFit_hmm}
\alias{SNPknock.fp.loadFit_hmm}
\title{Load the parameter estimates obtained by fastPHASE and assembles the HMM model for genotype data}
\usage{
SNPknock.fp.loadFit_hmm(r_file, alpha_file, theta_file, char_file,
  phased = FALSE)
}
\arguments{
\item{r_file}{a string with the path of the "_rhat.txt" file produced by fastPHASE.}

\item{alpha_file}{a string with the path of the "_alphahat.txt" file produced by fastPHASE.}

\item{theta_file}{a string with the path of the "_thetahat.txt" file produced by fastPHASE.}

\item{char_file}{a string with the path of the "_origchars" file produced by fastPHASE.}

\item{phased}{whether to assemble a model for phased haplotypes (default: FALSE).}
}
\value{
A structure describing the HMM fitted by fastPHASE.
}
\description{
This function loads the parameter estimates obtained by fastPHASE (see \link{SNPknock.fp.runFastPhase})
and assembles the HMM model for the genotype data (either unphased or phased), 
in the format required by the knockoff generation function \link{SNPknock.knockoffHMM}.
}
\details{
This function returns a structure with three fields: 
\itemize{
  \item{"pInit": a numerical array of length K, containing the marginal distribution of the hidden states for the first SNP.}
  \item{"Q": a numerical array of size (p-1,K,K), containing a list of p-1 transition matrices between the K latent states of the HMM.}
  \item{"pEmit": a numerical array of size (p,K,3), containing the emission probabilities of the hidden states for each of the p SNPs.}
 }
}
\examples{
# Specify the location of the fastPHASE output files containing the parameter estimates.
# Example files can be found in the package installation directory.
r_file = system.file("extdata", "genotypes_rhat.txt", package = "SNPknock")
alpha_file = system.file("extdata", "genotypes_alphahat.txt", package = "SNPknock")
theta_file = system.file("extdata", "genotypes_thetahat.txt", package = "SNPknock")
char_file = system.file("extdata", "genotypes_origchars", package = "SNPknock")

# Read the parameter files and build the HMM for unphased genotypes
hmm = SNPknock.fp.loadFit_hmm(r_file, alpha_file, theta_file, char_file)

# Read the parameter files and build the HMM for phased haplotypes
hmm = SNPknock.fp.loadFit_hmm(r_file, alpha_file, theta_file, char_file, phased=TRUE)

}
\references{
Scheet and Stephens,  A fast and flexible statistical model for large-scale population genotype data,
  Am J Hum Genet (2006).
  \href{http://www.sciencedirect.com/science/article/pii/S000292970763701X}{http://www.sciencedirect.com/science/article/pii/S000292970763701X}
}
\seealso{
Other fastPHASE: \code{\link{SNPknock.fp.loadFit}},
  \code{\link{SNPknock.fp.runFastPhase}},
  \code{\link{SNPknock.fp.writeX}}
}
