% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/print.R
\name{print.smle}
\alias{print.smle}
\alias{print.selection}
\alias{print.summary.smle}
\alias{print.summary.selection}
\alias{print.sdata}
\title{Print an object}
\usage{
\method{print}{smle}(x, ...)

\method{print}{selection}(x, ...)

\method{print}{summary.smle}(x, ...)

\method{print}{summary.selection}(x, ...)

\method{print}{sdata}(x, ...)
}
\arguments{
\item{x}{Fitted object.}

\item{...}{This argument is not used and listed for method consistency.}
}
\value{
Return argument invisibly.
}
\description{
This functions prints information about the fitted model from a call to \code{\link{SMLE}} or \code{\link{smle_select}},
 or about the simulated data from a call to \code{Gen_data}. The object passed as an argument to print is returned invisibly.
}
\examples{
set.seed(1)
Data<-Gen_Data(correlation="MA",family = "gaussian")
Data
fit<-SMLE(Data$Y,Data$X,k=20,family = "gaussian")
fit
summary(fit)
}
