% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sequencing.R
\name{randomNeedles}
\alias{randomNeedles}
\title{Simulate fine needle aspiration}
\usage{
randomNeedles(tumor, nsamples, threshold = 0.05)
}
\arguments{
\item{tumor}{A list which is the output of \code{\link{simulateTumor}()}.}

\item{nsamples}{The number of samples to take.}

\item{threshold}{Only mutations with an allele frequency greater than the threshold will be included in the sample.}
}
\description{
Simulate a sampling procedure which takes a fine needle through the simulated tumor and
reports the mutation allele frequency of the sampled cells.
}
\details{
This sampling procedure is inspired by Chkhaidze et. al. (2019) and simulates 
fine needle aspiration. A random one-dimensional cross-section 
of the tumor is chosen, and the cells within this cross section are sampled, reporting mutation allele frequency.
}
\examples{
out <- simulateTumor(N = 1000)
df <- randomNeedles(tumor = out, nsamples = 5)

}
\references{
K. Chkhaidze, T. Heide, B. Werner, M. Williams, W. Huang, G. Caravagna, T. Graham, and 
A. Sottoriva. Spatially con- strained tumour growth affects the 
patterns of clonal selection and neutral drift in cancer genomic data. PLOS Computational Biology, 2019.
 https://doi.org/10.1371/journal.pcbi.1007243.
}
\author{
Phillip B. Nicol
}
