% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stopstoILTM.R
\name{stopstoILTM}
\alias{stopstoILTM}
\title{Projects the GTFS stops table to Israel's TM grid}
\usage{
stopstoILTM(GTFSstops., useSIRI = FALSE, SIRI = NULL)
}
\arguments{
\item{GTFSstops.}{A subset of the GTFS stops table, should be the product of \code{\link{StopsForSIRI}}}

\item{useSIRI}{logical. use a SIRI data frame as reference?}

\item{SIRI}{if useSIRI is TRUE, which SIRI data frame to use?}
}
\value{
A \code{\link[sp]{SpatialPointsDataFrame}} with stops relevant to SIRI's real-time data
}
\description{
Projects a subset of the GTFS stops table to a \code{\link[sp]{SpatialPointsDataFrame}} With Israel's TM projection (epsg code 2039).
}
\details{
Requires the product of \code{\link{StopsForSIRI}},
is interchangeable with \code{\link{stopstoSP}}.
the function is a part of STG and should not be used on it's own.
}
\section{Warning}{

Do Not use this function on it's own, it is meant to be used only as part of the STG process
}

\references{
Bogin, D., Levy, N. and Ben-Elia E. (2018) \emph{Estimation of public transport service reliability using Big Data and open source tools}
}
\seealso{
\code{\link{STG}}, \code{\link{stopstoSP}}, \code{\link{StopsForSIRI}}
}
\keyword{internal}
\keyword{misc}
