% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/functions_qSIP_MAGs.R
\name{qSIP_bootstrap_fcr}
\alias{qSIP_bootstrap_fcr}
\title{Calculate adjusted bootstrap CI after for multiple testing for atom fraction excess using q-SIP method. Multiple hypothesis tests are corrected by}
\usage{
qSIP_bootstrap_fcr(
  atomX,
  isotope = "13C",
  n_sample = c(3, 3),
  ci_adjust_method = "fcr",
  n_boot = 10,
  parallel = FALSE,
  a = 0.1
)
}
\arguments{
\item{atomX}{A list object created by \code{qSIP_atom_excess_MAGs()}}

\item{isotope}{The isotope for which the DNA is labeled with ('13C' or '18O')}

\item{n_sample}{A vector of length 2. The sample size for data resampling (with replacement) for 1) control samples and 2) treatment samples.}

\item{ci_adjust_method}{Confidence interval adjustment method. Please choose 'FCR', 'Bonferroni', or 'none' (if no adjustment is needed). Default is FCR and also provides unadjusted CI.}

\item{n_boot}{Number of bootstrap replicates.}

\item{parallel}{Parallel processing. See \code{.parallel} option in \code{dplyr::mdply()} for more details.}

\item{a}{A numeric value. The alpha for calculating confidence intervals.}
}
\value{
A data.frame of atom fraction excess values (A) and atom fraction excess confidence intervals adjusted for multiple testing.
}
\description{
Calculate adjusted bootstrap CI after for multiple testing for atom fraction excess using q-SIP method. Multiple hypothesis tests are corrected by
}
\examples{
data(phylo.qSIP,GC_content)
\donttest{
### BD shift (Z) & atom excess (A)
atomX = qSIP_atom_excess_MAGs(phylo.qSIP,
                        control_expr='Isotope=="12C"',
                        treatment_rep='Replicate', Gi = GC_content)

### Add doParallel::registerDoParallel(num_cores) if parallel bootstrapping is to be done
df_atomX_boot = qSIP_bootstrap_fcr(atomX, n_boot=5, parallel = FALSE)
}

}
