% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions_L0_auxilary.R
\name{reduceDroneHaplo}
\alias{reduceDroneHaplo}
\title{Reduce drone's double haplotypes to a single haplotype}
\usage{
reduceDroneHaplo(haplo, pop)
}
\arguments{
\item{haplo}{\code{\link{matrix-class}}}

\item{pop}{\code{\link[AlphaSimR]{Pop-class}}}
}
\value{
matrix with one haplotype per drone instead of two - the order of
  individuals stays the same, but there will be less rows!
}
\description{
Level 0 function that returns one haplotype of drones, because
  we internally simulate them as diploid (doubled haploid). This is an
  internal utility function that you likely don't need to use.
}
\details{
While this function is meant to work on male (drone) haplotypes, we
  handle cases where the \code{haplo} matrix contains male and female
  haplotypes, which is why you need to provide \code{pop}. We only reduce
  haplotypes for males though.
}
\examples{
founderGenomes <- quickHaplo(nInd = 3, nChr = 1, segSites = 5)
SP <- SimParamBee$new(founderGenomes, csdChr = NULL)
\dontshow{SP$nThreads = 1L}
basePop <- createVirginQueens(founderGenomes)
drones <- createDrones(x = basePop[1], nInd = 2)

(tmp <- getSegSiteHaplo(drones, dronesHaploid = FALSE))
reduceDroneHaplo(haplo = tmp, pop = drones)

(tmp <- getSegSiteHaplo(c(basePop, drones), dronesHaploid = FALSE))
reduceDroneHaplo(haplo = tmp, pop = c(basePop, drones))
}
