% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/GLM_binary.R
\name{GLM_binary}
\alias{GLM_binary}
\title{Inference for single regression coefficient in high dimensional probit regression model}
\usage{
GLM_binary(
  X,
  y,
  index,
  model = "logistic1",
  intercept = TRUE,
  init.coef = NULL,
  lambda = NULL,
  mu = NULL,
  step = NULL,
  resol = 1.5,
  maxiter = 6,
  b0 = 0,
  alpha = 0.05,
  verbose = TRUE
)
}
\arguments{
\item{X}{Design matrix, of dimension \eqn{n} x \eqn{p}}

\item{y}{Outcome vector, of length \eqn{n}}

\item{index}{An integer between \eqn{1} and \eqn{p} indicating the index of the targeted regression coefficient. For example, \code{index} \eqn{= 1} means that the first regression coefficient is our inference target}

\item{model}{The fitted GLM, either \code{logistic1} or \code{logistic2} or \code{probit} or \code{inverse t1} (default = \code{logistic1}) ; \code{model}\eqn{=}\code{"logistic1"} uses \code{SIHR::LF_logistic} with \code{weight}\eqn{=}\code{NULL}; \code{model}\eqn{=}\code{"logistic2"} uses \code{SIHR::LF_logistic} with \code{weight}\eqn{=}\code{rep(1,n)}}

\item{intercept}{Should intercept be fitted for the initial estimator (default = \code{TRUE})}

\item{init.coef}{Initial estimator of the regression vector (default = \code{NULL})}

\item{lambda}{The tuning parameter used in the construction of \code{init.coef} (default = \code{NULL})}

\item{mu}{The dual tuning parameter used in the construction of the projection direction (default = \code{NULL})}

\item{step}{The step size used to compute \code{mu}; if set to \code{NULL} it is
computed to be the number of steps (< \code{maxiter}) to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = \code{NULL})}

\item{resol}{The factor by which \code{mu} is increased/decreased to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = 1.5)}

\item{maxiter}{Maximum number of steps along which \code{mu} is increased/decreased to obtain the smallest \code{mu}
such that the dual optimization problem for constructing the projection direction converges (default = 6)}

\item{b0}{The null value to be tested against}

\item{alpha}{Level of significance to test the null hypothesis that the target regression coefficient is equal to \code{b0} (default = 0.05)}

\item{verbose}{Should inetrmediate message(s) be printed (default = \code{TRUE})}
}
\value{
\item{prop.est}{The bias corrected estimator of the target regression coefficient}
\item{se}{The standard error of the bias-corrected estimator}
\item{CI}{The confidence interval for the target regression coefficient}
\item{decision}{\code{decision}\eqn{=1} implies the target regression coefficient is not equal to \code{b0} \eqn{\newline}
\code{decision}\eqn{=0} implies the target regression coefficient is equal to \code{b0}}
\item{proj}{The projection direction, of length \eqn{p}}
}
\description{
Computes the bias corrected estimator of a single regression coefficient in the high dimensional binary outcome regression model and the corresponding standard error.
It also constructs the confidence interval for the target regression coefficient and tests whether it is equal to a pre-specified value \code{b0}.
}
\examples{
\donttest{
sp = 20
n = 400
p = 800
f = function(x){
pnorm(x)
}
sig1 = toeplitz(seq(0.6, 0,length.out = p/10))
Sig = Matrix::bdiag(rep(list(sig1),10))+diag(rep(0.4,p))
X = MASS::mvrnorm(n, mu=rep(0,p), Sigma=Sig)
b = rep(0,p)
b[1:sp] = rep(c(0.4,-0.4), sp/2)
prob = f(X \%*\% b)
y = array(dim = 1)
for(i in 1:n){
y[i] = rbinom(1,1,prob[i])
}
Est = SIHR::GLM_binary(X = X, y = y, index = 1, model = "probit", intercept = FALSE)
}
}
\references{
\insertRef{glm}{SIHR}
}
