% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mean2.2014Thulin.R
\name{mean2.2014Thulin}
\alias{mean2.2014Thulin}
\title{Two-sample Test for Multivariate Means by Thulin (2014)}
\usage{
mean2.2014Thulin(X, Y, B = 100, nreps = 1000)
}
\arguments{
\item{X}{an \eqn{(n_x \times p)} data matrix of 1st sample.}

\item{Y}{an \eqn{(n_y \times p)} data matrix of 2nd sample.}

\item{B}{the number of selected subsets for averaging. \eqn{B\geq 100} is recommended.}

\item{nreps}{the number of permutation iterations to be run.}
}
\value{
a (list) object of \code{S3} class \code{htest} containing: \describe{
\item{statistic}{a test statistic.}
\item{p.value}{\eqn{p}-value under \eqn{H_0}.}
\item{alternative}{alternative hypothesis.}
\item{method}{name of the test.}
\item{data.name}{name(s) of provided sample data.}
}
}
\description{
Given two multivariate data \eqn{X} and \eqn{Y} of same dimension, it tests
\deqn{H_0 : \mu_x = \mu_y\quad vs\quad H_1 : \mu_x \neq \mu_y}
using the procedure by Thulin (2014) using random subspace methods. 
We did not enable parallel computing schemes for this in that it might incur 
huge computational burden since it entirely depends on random permutation scheme.
}
\examples{
## CRAN-purpose small example
smallX = matrix(rnorm(10*3),ncol=10)
smallY = matrix(rnorm(10*3),ncol=10)
mean2.2014Thulin(smallX, smallY, B=10, nreps=10) # run the test

\donttest{
## Compare with 'mean2.2011LJW' 
## which is based on random projection.
n = 33    # number of observations for each sample
p = 100   # dimensionality

X = matrix(rnorm(n*p), ncol=p)
Y = matrix(rnorm(n*p), ncol=p)

## run both methods with 100 permutations
mean2.2011LJW(X,Y,nreps=100,method="m")  # 2011LJW requires 'm' to be set.
mean2.2014Thulin(X,Y,nreps=100)
}

}
\references{
\insertRef{thulin_highdimensional_2014}{SHT}
}
\author{
Kisung You
}
