% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/SHAP_funcs.R
\name{shap.plot.dependence}
\alias{shap.plot.dependence}
\title{SHAP dependence plot with marginal histogram.}
\usage{
shap.plot.dependence(data_long, show_feature, dilute = FALSE,
  size0 = NULL, add_hist = T)
}
\arguments{
\item{data_long}{the long format SHAP values}

\item{show_feature}{which feature to show}

\item{dilute}{a number or logical, dafault to TRUE, will plot \code{nrow(data_long)/dilute} data. For example, if dilute = 5 will plot 1/5 of the data.}

\item{size0}{point size, default to 1 of nobs<1000, 0.4 if nobs>1000.}

\item{add_hist}{weather to add histogram using \code{ggMarginal}, default to TRUE.
But notice the plot after adding histogram it is \code{ggExtraPlot} object, cannot
add geom to that anymore. If wish to add more layers, turn the histogram off, or
maybe use the \code{\link{shap.plot.dependence}}.}
}
\value{
returns a ggplot2 object, could add further layers.
}
\description{
\code{shap.plot.dependence} is not colored by another variable,
\code{\link{shap.plot.dependence.color}} is the with color version.
Dependence plot is very easy to make if you have the SHAP values dataset
It is not necessary to start with the long-format data, but since I used that
for the summary plot, I just continue to use the long dataset
}
\examples{
# **SHAP dependence plot**
shap.plot.dependence.color(data_long = shap_long_iris, x="Petal.Length",
                           y = "Petal.Width", color_feature = "Petal.Width")
# the without color version, just plot SHAP value against feature value:
shap.plot.dependence(data_long = shap_long_iris, "Petal.Length")

}
