% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/R_utils_wC.R
\name{BinaryFiles}
\alias{readBinary}
\alias{saveBinary}
\title{Binary files}
\usage{
saveBinary(X, file = paste0(tempdir(), "/file.bin"), 
 type = c("float","double"), verbose = TRUE)
  
readBinary(file = paste0(tempdir(), "/file.bin"), 
  indexRow = NULL, indexCol = NULL, verbose = TRUE)
}
\arguments{
\item{X}{(numeric matrix) Data to save}

\item{file}{(character) Name of the binary file to save/read}

\item{type}{(character) Either 'float' or 'double' for single (4 bytes) or double precision (8 bytes), respectively,
that matrix to save will occupy}

\item{indexRow}{(integer vector) Which rows are to be read from the file. Default \code{indexRow=NULL} will read all the rows}

\item{indexCol}{(integer vector) Which columns are to be read from the file. Default \code{indexCol=NULL} will read all the columns}

\item{verbose}{\code{TRUE} or \code{FALSE} to whether printing file information}
}
\value{
Function 'saveBinary' does not return any value but print a description of the file saved. 

Function 'readBinary' returns the data that was read.
}
\description{
Save/read a numeric data as a fortran-formatted binary file at a defined precision (single or double).
}
\examples{
  require(SFSI)

  # Simulate matrix
  n = 1000; m = 5
  X = matrix(rnorm(n*m),ncol=m)
  head(X)
  
  # Save matrix
  saveBinary(X,paste0(tempdir(),"/Matrix1.bin"),type="double") # as double-precision
  saveBinary(X,paste0(tempdir(),"/Matrix2.bin"),type="float")  # as single-precision

  # Read the double-precision matrix
  X2 = readBinary(paste0(tempdir(),"/Matrix1.bin"))
  head(X2)
  max(abs(X-X2))     # No loss of precision
  object.size(X2)    # Size of the object

  # Read the single-precision matrix
  X3 = readBinary(paste0(tempdir(),"/Matrix2.bin"))
  head(X3)
  max(abs(X-X3))     # Loss of precision
  object.size(X3)    # But smaller-size object

  # Read specific rows and columns
  indexRow = c(2,4,5,8,10)
  indexCol = c(1,2,5)
  X2 = readBinary(paste0(tempdir(),"/Matrix1.bin"),indexRow=indexRow,indexCol=indexCol)
  X2
  # Equal to: 
  X[indexRow,indexCol]

}
\author{
Marco Lopez-Cruz (\email{maraloc@gmail.com}) and Gustavo de los Campos
}
