% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sss.line.r
\name{sss.line}
\alias{sss.line}
\title{Draw a Simple Systematic Sample (SSS) from a linear resource.}
\usage{
sss.line(x, n, spacing, random.start = TRUE)
}
\arguments{
\item{x}{A \code{SpatialLines} or \code{SpatialLinesDataFrame} object. 
This object must contain at least 1 line.}

\item{n}{Sample size.  Number of points to draw from the set of all lines
contained in \code{x}.  Specification of \code{n} takes precedence 
over specification of \code{spacing}.}

\item{spacing}{Assuming, \code{n} is not given, this is the distance 
between sample points on the amalgamated line 
in \code{x}. For example, if \code{x} is projected 
in UTM coordinates and \code{spacing=100}, the returned sample has one point 
every 100 meters along the amalgamated line in \code{x}. Keep in mind that the start
of line i+1 in \code{x} may not coincide with the end of line i in \code{x}, and that 
lines in \code{x} may not be straight.  Thus, 2-dimensional distances between
sample points will not, in general, equal \code{spacing}.}

\item{random.start}{Whether to start the sequence of points at a 
random place.  If \code{TRUE}, a random uniform variate is selected 
between 0 and either \code{spacing} or (length/\code{n}) and the first 
location is placed at that location along the line.  Subsequent points occur
every \code{spacing} units along the lines.  If \code{random.start==FALSE}, 
the first sample point occurs at 0 (first vertex of the lines).}
}
\value{
A \code{SpatialPointsDataFrame} containing locations in the SSS sample, in
order along the amalgamated line.  Those on line 1 appear first, those on line 2 
second, etc. Attributes of the sample points (in the 
embedded data frame) are 
as follows: 
\itemize{
  \item \code{sampleID}: A unique identifier for every sample point.  
  \code{sampleID} starts with 1 at the first point and 
  increments by one for each.  \code{sampleID} orders 
  sample points along the amalgamated line.
  \item \code{geometryID}: The ID of the lines object in \code{x} on which each 
  sample point falls.  The 
  ID of lines in \code{x} are \code{row.names(geometry(x))}. 
  \item Any attributes of the original lines (in \code{x}) on which each sample 
  point falls.
}


Additional attributes of the output object, beyond those which 
make it a \code{SpatialPointsDataFrame}, are:
\itemize{
   \item \code{frame}: Name of the input sampling frame.
   \item \code{frame.type}: Type of resource in sampling frame. (i.e., "line").
   \item \code{sample.type}: Type of sample drawn. (i.e., "SSS").
   \item \code{sample.spacing}: The spacing between sample points along the 
   amalgamated line. This is the input \code{spacing} parameter if specified,
   or is computed as (length/n) if \code{n} is specified.
   \item \code{random.start}: The random start of the systematic sample.  NA 
   corresponds to no random start.
}
}
\description{
Draws a systematic sample from a \code{SpatialLines*} object.  The 
\code{SpatialLines*} object represents a 2-dimensional line resource, such as a
river, highway, or coastline.
}
\details{
If \code{x} contains multiple lines, the lines are amalgamated before
sampling.   Conceptually, under amalgamation the lines in \code{x} are 
"stretched" straight and laid end-to-end in order of appearance in \code{x}.
The simple systematic sample is then drawn from the amalgamated line. 
Finally, sample points on the amalgamated line are mapped back to 2-dimensional 
space to fall on the lines in \code{x}. 

Note that spacing between sample points is enforced on the amalgamated 
line, and may not look correct if the lines loop back on themselves. 
For example, consider a line tracing a circle.  The spacing between 
the first and last sample point along the circle will not be the 
prescribed \code{spacing} because the circle starts between them. 
Spacing of all other points (2 to n-1) will be as requested.
}
\examples{

# Draw fixed number of equi-distant points
HI.samp <- sss.line( HI.coast, 100 )   
plot( HI.coast, col=rainbow(length(HI.coast)) )
points( HI.samp, col="red", pch=16 )

# Draw points every 20 km along Hawaii's coastline
HI.samp <- sss.line( HI.coast, spacing=20000 )   
plot( HI.coast, col=rainbow(length(HI.coast)) )
points( HI.samp, col="red", pch=16 )

# Inspect attributes of points with HI.samp@data

}
\seealso{
\code{\link{sss.polygon}}, \code{\link{sss.point}}, \code{\link{sdraw}}
}
\author{
Trent McDonald
}
\keyword{design}
\keyword{survey}
