% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hal.point.r
\name{hal.point}
\alias{hal.point}
\title{Draws a Halton Lattice sample from a discrete (point) resource.}
\usage{
hal.point(x, n, J = NULL, bases = c(2, 3))
}
\arguments{
\item{x}{A \code{SpatialPoints} or \code{SpatialPointsDataFrame} object. 
This object must contain at least 1 point.}

\item{n}{Sample size.  Number of locations to draw from the set of points
contained in \code{x}.}

\item{J}{A 2X1 vector of base powers.  \code{J[1]} is for horizontal,
\code{J[2]} for vertical dimension. \code{J} determines the size and shape
of the smallest Halton boxes. There are \code{bases[1]^J[1]} vertical columns 
of Halton boxes over \code{x}'s bounding box, and \code{bases[2]^J[2]} 
horizontal rows of Halton boxes over the bounding box, for a total 
of \code{prod(bases^J)} boxes.  The dimension of each box is 
\code{c(dx,dy)/(bases^J)}, where \code{c(dx,dy)} are the horizontal and 
vertical extents of \code{x}'s bounding box.  If \code{J=NULL} (the default),
\code{J} is chosen so that Halton boxes are as square as possible.}

\item{bases}{2X1 vector of Halton bases.  These must be co-prime.}
}
\value{
A \code{SpatialPointsDataFrame} containing locations in the HAL sample, 
in HAL order.
Attributes of the sample points are: 
\itemize{
  \item \code{sampleID}: A unique identifier for every sample point that 
  encodes the HAL order.  \code{return[order(return$sampleID),]} will sort the 
  returned object in HAL order.  \code{sampleID}'s, in the HAL case, are not 
  consecutive. \code{sampleID}'s are the Halton indices for the Halton boxes 
  containing the point, after adding random cycles to multiple points in 
  the same box (see \code{\link{halton.frame}}). If the sample cycled around
  to the beginning of the frame, because random start 
  fell at the end, the sample number is appended 
  to the beginning of the normal \code{sampleID}'s so they
  will sort the frame in the proper order.
  
  \item \code{HaltonIndex}: The index of the Halton box containing the point. 
  This column is not, in general, unique.  Points with the same \code{HaltonIndex}
  are in the same Halton box, and are "close" in space.
   
  \item \code{geometryID}: The ID of the sampled point in \code{x} The 
  ID of points in \code{x} are \code{row.names(x)}. 
  
  \item Any attributes of the original points (in \code{x}). 
}

Additional attributes of the output object, beyond those which 
make it a \code{SpatialPointsDataFrame}, are:
\itemize{
   \item \code{frame}: Name of the input sampling frame.
   \item \code{frame.type}: Type of resource in sampling frame. (i.e., "point").
   \item \code{sample.type}: Type of sample drawn. (i.e., "HAL").
   
   \item \code{J}: Exponents of the bases used to form the lattice of 
   Halton boxes. This is either the input \code{J}, or the \code{J} vector
   computed by \code{\link{halton.indices}}.  
   
   \item \code{bases}: Bases of the Halton sequence used to draw the sample. 
   
   \item \code{hl.box}: The bounding box around points in \code{x} used to 
   draw the sample.  See \code{\link{halton.indices}}.
   
   \item \code{random.start}: The random start of the sample in the Halton
   frame.  The Halton frame is a list of all points sorted in 
   Halton order.  Halton order is the Halton index of each point, with 
   random cycles added to multiple points 
   in the same Halton box.  
   This is a random number between 0 and the number of points in 
   \code{x} minus 1 .
   The sample consists of the 
   \code{n} consecutive units starting at \code{random.start+1} in 
   the sorted Halton frame. 
}
}
\description{
Draws a Halton Lattice sample from a \code{SpatialPoints*} object.
}
\details{
\bold{A brief description of Halton Lattice sampling for points:} 
Given a set of Halton Lattice parameters \code{J} and \code{bases},
a lattice of Halton boxes is constructed over the bounding box of the input points.  
This results in \code{prod(bases^J)} Halton boxes on the bounding box. 
The Halton index of all boxes is computed and assigned to points that lie 
in each box.  Points that lie in the same Halton box are randomly assigned 
unique Halton cycle numbers. This separates points in the same Halton box by
at least \code{prod(bases^J)} units when indices are mapped to the real line. 
Finally, a random number between 1 and the largest Halton (index+cycle) is 
drawn, and the next \code{n} units in the mapped real numbers are taken as 
the sample, restarting from the beginning if necessary.
}
\examples{

#   Draw sample of Hawaii coastline
#   This takes approximately 30 seconds to run
data(WA.cities)
samp <- hal.point( WA.cities, 100 )

#   Different lattice topology
samp <- hal.point( WA.cities, 100, J=c(10,4))
  

}
\author{
Trent McDonald
}
\seealso{
\code{\link{hal.line}}, \code{\link{hal.polygon}}, \code{\link{sdraw}}, 
\code{\link{bas.point}}
}
\keyword{design}
\keyword{survey}

